# Import the SDK and the client module
from label_studio_sdk.client import LabelStudio
import json
import sys, os
import copy
from tqdm import tqdm
import warnings

sys.path.append(os.path.dirname(os.path.dirname(os.path.dirname(os.path.abspath(__file__)))))
from gpt_api.unigpt import GPT
from gpt_tools.deepseek_tools import DeepseekChat

sys.path.append(os.path.dirname(os.path.dirname(os.path.abspath(__file__))))
from common_prompts import translate, translate_image, generate_reference_questions, LABEL_STUDIO_URL, API_KEY
from annotations2json import remove_image_path_prefix


def update_annotation_translation_caption(
    client,
    translation_captions: list,
    image_names: list,
    task_id: int,
    result_data: dict = None,  # type: ignore
):
    """update or add a new task in labelstudio which will contain the tranlations of captions

    Parameters
    ----------
    client : LabelStudio
        labelstudio client
    translation_captions : list
        the translations of captions
    image_names : list
        list of images' name
    task_id : int
        id of the task in labelstudio

    Returns
    -------
    None
    """
    if result_data != None:
        result = result_data
    else:
        result = []

    def key_not_exist(result, value_of_from_name: str):  # NOTE 可以加速, [True, False], image_id 作为 index
        not_exist = True
        if result != None:
            for data in result:
                if data.keys():
                    for key in data.keys():
                        if value_of_from_name == data[key]:  # value 是否存在于result里
                            not_exist = False
        return not_exist

    for image_id in range(len(image_names)):
        image_name_annotation = {
            "from_name": f"image_name_{image_id}",
            "to_name": f"image_{image_id}",
            "type": "choices",
            "value": {"choices": [image_names[image_id]]},
        }
        if key_not_exist(result, f"image_name_{image_id}"):
            result.append(image_name_annotation)  # type: ignore
        translation_caption_annotation = {
            "from_name": f"translation_to_caption_{image_id}",
            "to_name": f"image_{image_id}",
            "type": "textarea",
            "value": {"text": [translation_captions[image_id]]},
        }
        if key_not_exist(result, f"translation_to_caption_{image_id}"):
            result.append(translation_caption_annotation)  # type: ignore
    if annotations_id != None:
        client.annotations.update(
            id=annotations_id,
            result=result,
            was_cancelled=False,
            ground_truth=False,
        )
    else:
        client.annotations.create(
            id=task_id,
            result=result,
            was_cancelled=False,
            ground_truth=False,
        )


def update_task_translation_images(task, client, vl_agent, text_agent):
    """update task in labelstudio which will contain the tranlations of captions

    Parameters
    ----------
    task :
        task from labelstudio

    Returns
    -------
    None
    """
    warnings.warn("Using update_annotation_translation_images instead", DeprecationWarning)
    data_root_dir = "label_studio/data_to_annotate"
    # get some meta data to the task
    task_id = task.id
    project_id = task.project
    task_data = client.tasks.get(id=task_id)
    # get origin task data
    str_task_data = task_data.json()
    origin_task_data = json.loads(str_task_data)
    origin_task_data = origin_task_data["data"]
    # task data to updated
    task_data = copy.deepcopy(origin_task_data)

    def key_not_exist(dict_data, from_key: str):  # NOTE 可以加速, [True, False], image_id 作为 index
        not_exist = True
        if dict_data != None:
            if dict_data.keys():
                if from_key in dict_data.keys():
                    not_exist = False
        return not_exist

    try:
        for image_caption_index in range(len(origin_task_data["image_captions"])):
            image_caption = origin_task_data["image_captions"][image_caption_index]
            if key_not_exist(image_caption, "image_translation"):
                related_image_path = remove_image_path_prefix(image_caption["image"])
                task_data["image_captions"][image_caption_index]["image_translation"] = translate_image(
                    agent=vl_agent,
                    translate_agent=text_agent,
                    image_path=os.path.join(data_root_dir, related_image_path),
                )
        task_data["predict_question"] = generate_reference_questions(text_agent, origin_task_data["image_captions"])
        # with open("chartqa/data/test/test.json", "w") as f:
        #     json.dump(task_data, f, ensure_ascii=False, indent=2)
        client.tasks.update(
            id=task_id,
            data=task_data,
            project=project_id,
        )
        exit()
        return task_id, project_id, True
    except Exception as e:
        tqdm.write(f"ERROR: {e}")
        return task_id, project_id, False


def update_annotation_translation_images(task, client, vl_agent, text_agent):
    """update task in labelstudio which will contain the tranlations of captions

    Parameters
    ----------
    task :
        task from labelstudio

    Returns
    -------
    None
    """
    data_root_dir = "label_studio/data_to_annotate"
    # get some meta data to the task
    task_id = task.id
    project_id = task.project
    task_data = client.tasks.get(id=task_id)
    # get origin task data
    str_task_data = task_data.json()
    origin_task = json.loads(str_task_data)
    origin_task_data = origin_task["data"]

    result = []
    annotations_id = None

    if int(project_id) in [9, 7, 6, 4]:
        tqdm.write(f"this task: the language of {task_id} is Chinese")
        return task_id, project_id, True

    if len(origin_task["annotations"]) != 0:  # 已有标注
        for annotation in origin_task["annotations"]:
            if "are10032@outlook.com" in annotation["created_username"]:  # 如果是 qwen api 标注的就覆盖掉
                result = origin_task["annotations"][0]["result"]
                annotations_id = annotation["id"]
                # return task_id, project_id, True  # WARN 跳过qwen已经标注过的
                break
            result = origin_task["annotations"][0]["result"]
            annotations_id = origin_task["annotations"][0]["id"]
            for result_item in result:
                if "from_name" in result_item.keys():
                    if (
                        result_item["from_name"] == "if_can_be_labeled_question"
                    ):  # 如果这个问题已经被标注人员标过了, 跳过
                        tqdm.write(f"this task: {task_id} has been labeled")
                        return task_id, project_id, True
    else:
        result = []  # 还没有被标注同事或 Qwen api 标过
        annotations_id = None

    def key_not_exist(result, value_of_from_name: str):  # NOTE 可以加速, [True, False], image_id 作为 index
        return_result = []
        not_exist = True
        if result != None:
            for data in result:
                if_append = True
                if data.keys():
                    for key in data.keys():
                        if value_of_from_name == data[key]:  # value 是否存在于result里
                            not_exist = False
                            translate_text = data["value"]["text"][0]
                            if len(translate_text) < 4:
                                if_append = False
                                not_exist = True
                if if_append:
                    return_result.append(data)
        return not_exist, return_result

    try:
        for image_id in range(len(origin_task_data["image_captions"])):
            exist, result = key_not_exist(result, f"translation_to_image_{image_id}")
            if exist:
                image_caption = origin_task_data["image_captions"][image_id]
                related_image_path = remove_image_path_prefix(image_caption["image"])
                image_translation_text = translate_image(
                    agent=vl_agent,
                    translate_agent=text_agent,
                    image_path=os.path.join(data_root_dir, related_image_path),
                )
                image_translation = {
                    "from_name": f"translation_to_image_{image_id}",
                    "to_name": f"image_{image_id}",
                    "type": "textarea",
                    "value": {"text": [image_translation_text]},
                }
                result.append(image_translation)  # type: ignore

        with open("chartqa/data/test/test_image_translate.json", "w") as f:
            json.dump(result, f, ensure_ascii=False, indent=2)

        # client.predictions.create(id=task_id, result=result)
        if annotations_id != None:
            client.annotations.update(
                id=annotations_id,
                result=result,
                was_cancelled=False,
                ground_truth=False,
            )
        else:
            client.annotations.create(
                id=task_id,
                result=result,
                was_cancelled=False,
                ground_truth=False,
            )
        # exit()  # HACK
        return task_id, project_id, True
    except Exception as e:
        tqdm.write(f"ERROR: {e}")
        # exit()  # HACK
        return task_id, project_id, False


def update_annotation_reference_question(task, client, text_agent):
    """update task in labelstudio which will contain reference questions

    Parameters
    ----------
    task :
        task from labelstudio

    Returns
    -------
    None
    """
    # get some meta data to the task
    task_id = task.id
    project_id = task.project
    task_data = client.tasks.get(id=task_id)
    # get origin task data
    str_task_data = task_data.json()
    origin_task = json.loads(str_task_data)
    origin_task_data = origin_task["data"]

    result = []
    annotations_id = None

    if len(origin_task["annotations"]) != 0:  # 已有标注
        for annotation in origin_task["annotations"]:
            if "are10032@outlook.com" in annotation["created_username"]:  # 如果是 qwen api 标注的就覆盖掉
                result = origin_task["annotations"][0]["result"]
                annotations_id = annotation["id"]
                # return task_id, project_id, True  # WARN 跳过qwen已经标注过的
                break
            result = origin_task["annotations"][0]["result"]
            annotations_id = origin_task["annotations"][0]["id"]
            for result_item in result:
                if "from_name" in result_item.keys():
                    if (
                        result_item["from_name"] == "if_can_be_labeled_question"
                    ):  # 如果这个问题已经被标注人员标过了, 跳过
                        tqdm.write(f"this task: {task_id} has been labeled")
                        return task_id, project_id, True
    else:
        result = []  # 还没有被标注同事或 Qwen api 标过
        annotations_id = None

    def key_not_exist(result, value_of_from_name: str):  # NOTE 可以加速, [True, False], image_id 作为 index
        not_exist = True
        if result != None:
            for data in result:
                if data.keys():
                    for key in data.keys():
                        if value_of_from_name == data[key]:  # value 是否存在于result里
                            not_exist = False
        return not_exist

    try:
        if key_not_exist(result, f"refer_question_from_qwen"):
            reference_questions_text = generate_reference_questions(text_agent, origin_task_data["image_captions"])
            reference_questions = {
                "from_name": f"refer_question_from_qwen",
                "to_name": f"global_task_context",
                "type": "textarea",
                "value": {"text": [reference_questions_text]},
            }
            result.append(reference_questions)  # type: ignore
        else:
            tqdm.write(f"this task: {task_id} has been labeled")
            return task_id, project_id, True  # INFO 已经被qwen标过参考问题了

        with open("chartqa/data/test/test_reference_question.json", "w") as f:
            json.dump(result, f, ensure_ascii=False, indent=2)

        # client.predictions.create(id=task_id, result=result)
        if annotations_id != None:
            client.annotations.update(
                id=annotations_id,
                result=result,
                was_cancelled=False,
                ground_truth=False,
            )
        else:
            client.annotations.create(
                id=task_id,
                result=result,
                was_cancelled=False,
                ground_truth=False,
            )
        # exit()  # HACK
        return task_id, project_id, True
    except Exception as e:
        tqdm.write(f"ERROR: {e}")
        # exit()  # HACK
        return task_id, project_id, False


if __name__ == "__main__":
    # Connect to the Label Studio API and check the connection
    client = LabelStudio(base_url=LABEL_STUDIO_URL, api_key=API_KEY)
    deepseek_chat = DeepseekChat(temp=1.3)
    qwen_chat = GPT(model="qwen3_32b", vendor="", stream=False, temperature=0.2)

    for project in client.projects.list():
        if project.id == 1 or project.title == "chartQA":
            tasks = client.tasks.list(project=project.id, include="id")
            for task in tqdm(tasks):
                task_id = task.id
                task_data = client.tasks.get(id=task_id)
                annotations_id = None
                result_data = None
                if len(task_data.annotations) != 0:  # type: ignore
                    annotations_id = task_data.annotations[0].id  # type: ignore
                    annotations_data = client.annotations.get(id=annotations_id)  # type: ignore
                    result_data = json.loads(annotations_data.json())["result"]

                image_captions = task_data.data["image_captions"]
                translation_captions = []
                image_names = []
                for image_id in range(len(image_captions)):  # type: ignore
                    image_caption = image_captions[image_id]  # type: ignore
                    image_name = image_caption["image_name"]
                    caption = image_caption["caption"]
                    # translation_caption = caption
                    # translation_caption = translate(deepseek_chat, caption)  # NOTE
                    translation_caption = translate(qwen_chat, caption)  # NOTE
                    translation_captions.append(translation_caption)
                    image_names.append(image_name)
                tqdm.write(f"{task_id}, {translation_captions}")
                # exit()
                update_annotation_translation_caption(
                    client, translation_captions, image_names, task_id, annotations_id, result_data  # type: ignore
                )
                # exit()
