# Import the SDK and the client module
from label_studio_sdk.client import LabelStudio
import json
import copy
import sys, os

sys.path.append(os.path.dirname(os.path.dirname(os.path.abspath(__file__))))
from gpt_api.unigpt import GPT
from tqdm import tqdm
from gpt_tools.deepseek_tools import DeepseekChat
import annotations2json
from annotations2json import process_origin_tasks_jsons as process_origin_tasks_jsons
from common_prompts import translate as translate
from common_prompts import LABEL_STUDIO_URL as LABEL_STUDIO_URL
from common_prompts import API_KEY as API_KEY


def update_file_translation_caption(processed_data, file_path, output_path):
    """add translation of captions in json from the task of labelstudio

    Parameters
    ----------
    processed_data : dict
        the dict which is parsed from label studio tasks
    file_path : str
        original json task file path
    output_path : str
        output json task file path
    """
    annotations_result_figures = processed_data["annotations_result_figures"]
    json_path = os.path.join(file_path, processed_data["id"]["pub_id"] + ".json")
    output_json_path = os.path.join(output_path, processed_data["id"]["pub_id"] + ".json")
    # processed_json = None
    if os.path.exists(json_path):
        with open(json_path, "r") as f:
            origin_file_json = json.load(f)
            processed_json = copy.deepcopy(
                origin_file_json
            )  # just add the "caption_translation" key-value to origin json
            for i in range(len(origin_file_json["data"]["image_captions"])):
                image_name = processed_json["data"]["image_captions"][i]["image_name"]
                if "caption_translation" in annotations_result_figures[image_name].keys():
                    processed_json["data"]["image_captions"][i]["caption_translation"] = annotations_result_figures[
                        image_name
                    ]["caption_translation"]
        with open(output_json_path, "w", encoding="utf-8") as f:
            json.dump(processed_json, f, ensure_ascii=False, indent=4)
            tqdm.write(f"saved file: {output_json_path}")


if __name__ == "__main__":
    # Connect to the Label Studio API and check the connection
    client = LabelStudio(base_url=LABEL_STUDIO_URL, api_key=API_KEY)
    deepseek_chat = DeepseekChat(temp=1.3)
    qwen_chat = GPT(model="qwen3_32b", vendor="", stream=False, temperature=0.2)

    file_path = "data/chartQA/label_studio_formal/data_to_annotate/spiqa/SPIQA_testC_Images/jsons"
    output_path = "data/chartQA/label_studio_formal/data_to_annotate/spiqa_1/SPIQA_testC_Images/jsons"

    for project in client.projects.list():
        if project.id == 1 or project.title == "chartQA":
            tasks = client.tasks.list(project=project.id, include="id")
            for task in tqdm(tasks):
                task_id = task.id
                task_data = client.tasks.get(id=task_id)

                filename = task_data.data["file_name"]
                # print(f"task_data.annotations###########\n{task_data.annotations}")

                annotations_id = None
                result_data = None
                if len(task_data.annotations) != 0:  # type: ignore
                    annotations_id = task_data.annotations[0].id  # type: ignore
                    # annotations_data = client.annotations.get(id=annotations_id)
                    # annotations_data = task_data.annotations[0].json()
                    annotations_data = json.loads(task_data.json())

                    # print(f"annotations_data###########\n{annotations_data}")
                    # result_data = json.loads(annotations_data.json())["result"]

                    processed_data = process_origin_tasks_jsons(
                        annotations_data,
                        annotations2json.data_struct,
                        annotations2json.annotation_figure_struct,
                    )

                    tqdm.write(f"{task_id}")
                    update_file_translation_caption(processed_data, file_path, output_path)
                    # exit()
