import sys, os
import re
from loguru import logger
from typing import Union, Dict, List, Optional
import copy
from pathlib import Path
from collections import deque
from transformers import AutoTokenizer
import base64
from tqdm import tqdm
from PIL import Image
import io

sys.path.append(os.path.dirname(os.path.dirname(os.path.dirname(os.path.abspath(__file__)))))
from gpt_api.unigpt import GPT


def encode_image(picture_path, max_dimension: int = 240):
    try:
        with Image.open(picture_path) as img:
            original_format = img.format
            width, height = img.size
            if width <= max_dimension and height <= max_dimension:
                resized_img = img
            else:
                if width > height:
                    new_width = max_dimension
                    new_height = int(max_dimension * height / width)
                else:
                    new_height = max_dimension
                    new_width = int(max_dimension * width / height)
                resized_img = img.resize((new_width, new_height), Image.Resampling.LANCZOS)
            byte_stream = io.BytesIO()
            resized_img.save(byte_stream, format=original_format)
            image_bytes = byte_stream.getvalue()
            # print(base64.b64encode(image_bytes).decode("utf-8"))
            return base64.b64encode(image_bytes).decode("utf-8")
    except FileNotFoundError:
        logger.error(f"file not found {picture_path}")
        return None
    except Exception as e:
        logger.error(f"error: {e}")
        return None


# def encode_image(picture_path):
#     with open(picture_path, "rb") as image_file:
#         return base64.b64encode(image_file.read()).decode("utf-8")


def if_chart(agent, image_path: str):
    judge_prompt = f'You are an expert data labeler. Your task is to identify whether the given image is a chart or a table. Charts contains different types like [Line, Bar, Pie, Scatter, Radar, Candlestick, Boxplot, Heatmap, Graph, Tree, Sunburst, Sankey, Funnel, Area, 3D], all these different chart types can be chart. You only need to answer "True" or "False" and put your answer in <answer>...</answer>.'
    prompt = [
        {"type": "image_url", "image_url": {"url": f"data:image/jpg;base64,{encode_image(image_path)}"}},
        {"type": "text", "text": judge_prompt},
    ]
    message_text = [{"role": "user", "content": prompt}]
    logger.info(f"agent.send_chat_request()")
    result, _, _, _ = agent.send_chat_request(message_text)
    logger.info(f"{result}")

    # pattern = r"<answer>(.*?)</answer>"
    # match = re.search(pattern, result, re.DOTALL)
    # if match:
    #     answer = match.group(1).strip()
    if "true" in result.lower():
        return True
    elif "false" in result.lower():
        return False
    return None


def extract_context(agent, image_name: str, context: list):
    full_text = "\n".join(context)
    system_prompt = f"""
    You are an experienced data annotation engineer. I will provide you with a block of plain text in Markdown format and the filename of an image. The Markdown text will be enclosed in <md></md> tags, and the image filename will be in <image></image> tags.

    Your task is to find the text description context which containing full or partial paragraph descriptions within the Markdown that related to the image. Then, you must place this exact, original text inside <answer></answer> tags.

    Important: The text within the <answer></answer> tags must be the verbatim text from the source. Do not make any changes, modifications, or additions. Simply extract it as is.
    """

    example_prompt = f"""
    Here is a example:

    The Markdown text is: <md># 8.2 网络演算模型,
            网络演算采用随机网络演算算法，提出基于网络质量概率演算的算法。基于概率的网络演算设计思想由以下三部分构成：
            (1) 引入概率演算，业务流的微突发导致排队等待时延累积概率服从负 e指数分布，通过设置概率阈值，得到突发量，来优化达到曲线中的突发量。对于轻载情形，极大地优化微突发引起的时延抖动估计；
            (2) 采用上游最大服务能力，修正下游到达曲线。上游节点的突发会进入到下游节点，根据上游节点的突发量，优化下游节点的到达曲线，进一步收紧时延上界；
            (3) 将笼统的时延上界计算替代为逐跳时延上界考察。为了便于路径的搜索和计算，需要逐跳的计算节点的时延上界，保障端到端时延的确定性。
            通过以上解决方案，可以大大优化时延上界估计，明显减弱长尾效应，同时适用于轻载和重载情形，支持转发面多种调度方式。网络演算算法模型如图 17 所示，到达曲线ɑ由多段组成，其中多端口汇聚导致的报文碰撞演算出突发量 M，峰值速率p 根据上游实际等效速率进行优化，上游的突发量累积到下游演算出实际突发 b，再根据不同的转发面调度方式，构建出不同的服务曲线β。
            ![a0c976c3e235c06a349f17540a97df850f736338181fabee598aff48928a6712](images/a0c976c3e235c06a349f17540a97df850f736338181fabee598aff48928a6712.jpg)
            图 17 网络演算建模
            需求参数包括从设备侧获取的调度方式及整形器参数、端口数据的周期内流速、端口服务能力，业务流获取的参数包括 T-spec 参数和端到端时延需求，以及配置的概率阈值和获取的拓扑数据。根据最大业务包长、链路带宽、调度算法及整形参数和周期内流速，可以精确刻画业务的到达曲线，达到数据轻量级需求。算法可以对微突发定量化描述，通过概率的演算极大地优化微突发引起的时延抖动估计，能够识别大流速汇聚到小带宽的情形，从而避免局部拥塞。在轻载的情形下可以有效收紧时延上界。
            通过网络演算规划工具具有以下功能：
            对业务进行路径选择，并预留相应的资源；
            对网络进行性能仿真；
            对网络流量进行调优。
            # 8.3 网络演算仿真与验证
            图 18 网络演算测试组网图</md>
    The image filename is: <image>![a0c976c3e235c06a349f17540a97df850f736338181fabee598aff48928a6712](images/a0c976c3e235c06a349f17540a97df850f736338181fabee598aff48928a6712.jpg)</image>

    The answer is <answer>8.2 网络演算模型
            网络演算采用随机网络演算算法，提出基于网络质量概率演算的算法。基于概率的网络演算设计思想由以下三部分构成：
            (1) 引入概率演算，业务流的微突发导致排队等待时延累积概率服从负 e指数分布，通过设置概率阈值，得到突发量，来优化达到曲线中的突发量。对于轻载情形，极大地优化微突发引起的时延抖动估计；
            (2) 采用上游最大服务能力，修正下游到达曲线。上游节点的突发会进入到下游节点，根据上游节点的突发量，优化下游节点的到达曲线，进一步收紧时延上界；
            (3) 将笼统的时延上界计算替代为逐跳时延上界考察。为了便于路径的搜索和计算，需要逐跳的计算节点的时延上界，保障端到端时延的确定性。
            通过以上解决方案，可以大大优化时延上界估计，明显减弱长尾效应，同时适用于轻载和重载情形，支持转发面多种调度方式。网络演算算法模型如图 17 所示，到达曲线ɑ由多段组成，其中多端口汇聚导致的报文碰撞演算出突发量 M，峰值速率p 根据上游实际等效速率进行优化，上游的突发量累积到下游演算出实际突发 b，再根据不同的转发面调度方式，构建出不同的服务曲线β。
            图 17 网络演算建模</answer>.
    """

    user_prompt = f"""
    Now, you need to extract the descriptions related to the image.

    Here is the Markdown text: <md>{full_text}</md>
    The image filename is: <image>{image_name}</image>

    Remember to answer within the <answer></answer> tags.
    """

    message_text = [
        {"role": "system", "content": system_prompt},
        {"role": "user", "content": example_prompt},
        {"role": "user", "content": user_prompt},
    ]
    result, _, _, _ = agent.send_chat_request(message_text)
    # logger.info(f"{result}")

    pattern = r"<answer>(.*?)</answer>"
    match = re.search(pattern, result, re.DOTALL)
    if match:
        return match.group(1).strip()
    else:
        raise
