import torch
import argparse
import time
from parsers.parser import Parser
from parsers.config import get_config, get_constraint_config
from trainer import Trainer
from sampler import Sampler, Sampler_mol


def main(work_type_args):
    ts = time.strftime('%b%d-%H:%M:%S', time.gmtime())
    args = Parser().parse()
    config = get_config(args.config, args.seed)

    # -------- Train --------
    if work_type_args.type == 'train':
        trainer = Trainer(config, device=args.device) 
        ckpt = trainer.train(ts)
        if 'sample' in config.keys():
            constraint_config = get_constraint_config(args.constr_config)
            config.ckpt = ckpt
            sampler = Sampler(config, constraint_config, device=args.device) 
            sampler.sample()

    # -------- Generation --------
    elif work_type_args.type == 'sample':
        constraint_config = get_constraint_config(args.constr_config)
        if config.data.data in ['QM9', 'ZINC250k']:
            sampler = Sampler_mol(config, constraint_config, device=args.device)
        else:
            sampler = Sampler(config, constraint_config, device=args.device) 
        sampler.sample()
        
    else:
        raise ValueError(f'Wrong type : {work_type_args.type}')

if __name__ == '__main__':

    work_type_parser = argparse.ArgumentParser()
    work_type_parser.add_argument('--type', type=str, required=True)
    main(work_type_parser.parse_known_args()[0])
