import scipy as sp
import numpy as np
import torch

def epigraph_projection (x, M: torch.tensor, b: torch.tensor):
    Minv = torch.linalg.pinv(M)
    return x - Minv @ (M @ x - b)


def sublevel_projection (x, phi, delta, phi_name):
    if phi (x) <= delta:
        return x
    else:
        # lambdastar found using bijection.
        return proximal(x, lambdastar, phi, phi_name)

