## L-MSA: Layer-wise Fine-tuning using the Method of Successive Approximations

This repo provides starter code for the paper L-MSA: Layer-wise Fine-tuning using the Method of Successive Approximations.

<!-- The purpose of this repo is to provide a sample implementation of surgical fine-tuning, which is simple to add to existing codebases: just optimize the parameters in the desired layers. Here we provide some sample code for running on CIFAR-C and ImageNet-C datasets. -->
The fine-tuning pipeline is all in `main.py` with argument configs for the datasets in `config/`.

### Environment

Create an environment with the following command:
```
conda env create -f conda_env.yml
```


### **Sample Commands for Surgical Fine-Tuning**

Before running, download the data ([CIFAR-10C](https://zenodo.org/record/2535967) or [ImageNet-C](https://zenodo.org/record/2235448)) and update the paths in the configs accordingly.

```
python main.py --config-name='cifar-10c'
python main.py --config-name='imagenet-c'
```
For dataset Cifar-Flip, set data.flip = Ture in the configuration file cifar-10c.yaml.  
For dataset living-17 , set data.dataset_name: living17 in the configuration file imagenet-c.yaml. 

To calculate the metric for layer selection and print the results, uncomment line 361 in main.py when $args.opt$ is set to $EMSA$.
To fine-tune a specific layer, set $args.layerwise$ to the index of the desired layer within $all\_blocks$.

For other setups, modify the configuration file accordingly. 