# FedRAP

> This project is the code of "Federated Recommendation with Additive Personalization"(***tentative***)

## Introduction

**FedRAP** is a federated recommendation system, currently focuses on the task with implicit feedback.

It is implemented by using Python and Pytorch.

## Requirements

- The code is built on `python=3.8`

- all requirements are in the file `requirements.txt`. To install these, please run

  `pip install -r requirements.txt`

## Quick Start

- Two folders should be firstly created in the root folder: `logs` and `results`.

- Please change the dataset folder in the line 66 of `train.py`.

- To run FedRAP:

  `python train.py --alias='FedRAP' --dataset='movielens' --data_file='ml-100k.dat' --regular='l1' --l2_regularization=1e-4 --lambda=1e-1 --mu=1e-1 --lr_network=5e-1 --lr_args=2e2`

### Hyperparameters

| Dataset    | $\lambda$ | $\mu$ | l2_reg | lr_network | lr_args |
| ---------- | :-------: | :---: | :----: | :--------: | :-----: |
| ML-100K    |    0.1    |  0.1  | 0.0001 |    0.5     |   200   |
| ML-1M      |   0.01    | 0.01  | 0.0001 |    0.5     |  1000   |
| Video      |   0.001   | 0.01  | 0.001  |    0.01    |   100   |
| LastFM-2K  |    0.1    |   1   | 0.0001 |    0.01    |   100   |
| QB-article |  0.0001   |  0.1  | 0.0001 |    0.01    |  1000   |
