# Exploring Edge Probability Graph Models Beyond Edge Independency

## Preparation: Generate EIGMs

```
cd data
python kron_seed.py
python er_cl_gen.py
python sbm_gen.py
```

## Fitting

See the `fitting` subfolder.

- For ER, we use the Wolfram Language for better numerical accuracy. You can use gradient descent too.
- For the other models, we use gradient descent in PyTorch. We use PyTorch 1.9.0.

Run the fitting code

```
cd fitting
bash fitting.sh all
```

The fit results will be in the `fit_res` subfolder.

## Generation
See the `generation` subfolder.

- All the generation code is written in C++ with OpenMP

Run the generation code

```
cd generation
bash compile.sh
bash gen.sh
```

The fit results will be in the `gen_res` subfolder.
