import argparse

def get_parameter():
    parser = argparse.ArgumentParser(description='')

    parser.add_argument('-device', default='cuda', type=str, help='cuda/cpu')
    parser.add_argument('-datadir', default='./root', type=str, help='data directory')
    parser.add_argument('-outdir', default='./outputs', type=str, help='output directory')
    parser.add_argument('-logdir', default='./logs', type=str, help='log director')
    parser.add_argument('-craftproj', default='craft', type=str, help='craft project')
    parser.add_argument('-dataset', default='CIFAR', type=str, help='dataset')
    parser.add_argument('-adv', default='pgd', type=str, help='adversarial attack')
    parser.add_argument('-unlearn', default='first', type=str, help='unlearning method')
    parser.add_argument('-opt', default='SGD', type=str, help='optimizer')

    parser.add_argument('-K', default=[], type=int, nargs='+', help='knn scale')
    parser.add_argument('-c', default=1, type=int, help='number of unlearning samples')
    parser.add_argument('-t', default=5, type=int, help='number of unlearning samples at a time')
    parser.add_argument('-P', default=5000, type=int, help='pooling size')
    parser.add_argument('-test_samples', default=1, type=int, help='number of test samples')
    parser.add_argument('-lam', default=10, type=float, help='lamda')
    parser.add_argument('-dim', default=100, type=int, help='local density scale')
    parser.add_argument('-can', default=500, type=int, help='candidates')

    parser.add_argument('-epoch', default=100, type=int, help='retraining epoch')
    parser.add_argument('-lr', default=0.001, type=float, help='learning rate')
    parser.add_argument('-tau', default=0.0001, type=float, help='initial unlearning rate')
    parser.add_argument('-un_lr', default=0.0001, type=float, help='unlearning rate')
    parser.add_argument('-finetune_epoch', default=1, type=int, help='fine-tuning epoch')

    return parser.parse_args()