## Rethinking Adversarial Robustness in the Context of the Right to be Forgotten
### Implementation of AdvUA

Create an environment in Anaconda and install all the packages
```
python==3.7.16
numpy==1.21.6
pytorch==2.0.0
torchvision==0.15.0 
advertorch==0.2.4 
scikit-learn==1.0.2
scipy==1.7.3 
```

To run the adversarial unlearning attack (AdvUA) framework, execute the example command in the main directory. The `main.py` first loads an undefended model using natural training algorithm and a defended model using adversarial training technique, then it computes the distances of target test samples and training samples from representation space, and finally find the unlearning samples using empirical search.

```
python main.py -dataset=CIFAR -K 100 -c=50 -test_samples=5 -adv=pgd
```

Here is a description of the parameters. The detailed parameter settings are given in `utils/parser.py`.
- `-dataset` dataset name
- `-K` k nearest-neighbor samples
- `-c` number of unlearning samples
- `-test_samples` number of target test samples
- `-adv` type of adversarial attack
