import torch
import torch.nn as nn
import torch.nn.functional as F

class ConvNet2(nn.Module):
    def __init__(self, num_classes=10):
        super(ConvNet2, self).__init__()
        self.layer1 = nn.Sequential(
            nn.Conv2d(1, 32, kernel_size=5, stride=1, padding=2),
            nn.ReLU(),
            nn.MaxPool2d(kernel_size=2, stride=2))
        self.layer2 = nn.Sequential(
            nn.Conv2d(32, 64, kernel_size=5, stride=1, padding=2),
            nn.ReLU(),
            nn.MaxPool2d(kernel_size=2, stride=2))
        self.relu = nn.ReLU()
        self.fc1 = nn.Linear(7 * 7 * 64, 1024)
        self.fc2 = nn.Linear(1024, num_classes)

    def forward(self, x, out_keys=False):
        out_layer = {}

        out = self.layer1(x)
        out = self.layer2(out)
        out = out.reshape(out.size(0), -1)
        out = self.relu(self.fc1(out))
        out_layer['fc1'] = out
        out = self.fc2(out)
        out_layer['fc2'] = out

        if out_keys:
            return out_layer
        else:
            return out

class ConvNet5(nn.Module):
    def __init__(self, widths=[16, 32, 32, 64, 64], in_channels=3, num_classes=10, batchnorm=False):
        super(ConvNet5, self).__init__()

        blocks = []
        width_in = in_channels
        for width in widths:
            blocks.append(self.convblock(width_in, width, batchnorm))
            width_in = width

        self.features = nn.Sequential(*blocks)
        self.linear = nn.Linear(widths[-1], num_classes)

    def forward(self, x, penu=False):
        out = self.penultimate(x)
        if penu:
            return out
        out = self.linear(out)
        return out

    def penultimate(self, x):
        out = self.features(x)
        out = out.view(out.size(0), -1)
        return out

    def convblock(self, width_in, width_out, batchnorm):
        if batchnorm:
            bn = torch.nn.BatchNorm2d(width_out)
        else:
            bn = torch.nn.Identity()
        return nn.Sequential(nn.Conv2d(width_in, width_out, kernel_size=3, padding=1),
                                   torch.nn.ReLU(),
                                   nn.Dropout(0.3),
                                   bn,
                                   torch.nn.MaxPool2d(2, 2))
