SUBJECT=m00183
ELECTRODE=T1cIf13
TRIAL=trial001
#fewshot deep baseline
TASK_NAME=onset_finetuning
RUN_NAME=deep_linear_wav_baseline
python3 -m testing.run_fewshot_training_tests +exp=feature_extract +data=finetuning_template +model=deep_linear_wav_baseline +task=baseline_wav_task +criterion=baseline_criterion +preprocessor=wav_preprocessor ++data.electrodes=[${ELECTRODE}] ++data.cached_data_array=/storage/user123/self_supervised_seeg/cached_data_arrays ++data.name=${TASK_NAME} ++data.train_fewshot=??? ++data.reload_caches=??? +test=fewshot_test ++test.out_dir=/storage/user123/self_supervised_seeg/fewshot_test/${RUN_NAME} ++data.subject=${SUBJECT} ++data.brain_runs=[${TRIAL}] 

#stft large pretrained feature extract
RUN_NAME=stft_large_pretrained_feature_extract
python3 -m testing.run_fewshot_training_tests +exp=feature_extract +data=finetuning_template +model=feature_extract_model +task=feature_extract +criterion=feature_extract_criterion +preprocessor=stft_pretrained ++preprocessor.upstream_ckpt=/storage/user123/self_supervised_seeg/pretrained_weights/stft_large_pretrained.pth ++data.electrodes=[${ELECTRODE}] ++data.cached_data_array=/storage/user123/self_supervised_seeg/cached_data_arrays ++data.train_fewshot=??? ++data.reload_caches=??? +test=fewshot_test ++test.out_dir=/storage/user123/self_supervised_seeg/fewshot_test/${RUN_NAME} ++data.subject=${SUBJECT} ++data.brain_runs=[${TRIAL}]  ++data.cache_input_features=/storage/user123/self_supervised_seeg/cached_input_features/temp_features_${RUN_NAME}/${TASK_NAME} ++data.name=${TASK_NAME} 

#superlet large pretrained feature extract
RUN_NAME=superlet_large_pretrained_feature_extract
python3 -m testing.run_fewshot_training_tests +exp=feature_extract +data=finetuning_template +model=feature_extract_model +task=feature_extract +criterion=feature_extract_criterion +preprocessor=superlet_pretrained ++preprocessor.upstream_ckpt=/storage/user123/self_supervised_seeg/pretrained_weights/superlet_large_pretrained.pth ++data.electrodes=[${ELECTRODE}] ++data.cached_data_array=/storage/user123/self_supervised_seeg/cached_data_arrays ++data.train_fewshot=??? ++data.reload_caches=??? +test=fewshot_test ++test.out_dir=/storage/user123/self_supervised_seeg/fewshot_test/${RUN_NAME} ++data.subject=${SUBJECT} ++data.brain_runs=[${TRIAL}]  ++data.cache_input_features=/storage/user123/self_supervised_seeg/cached_input_features/temp_features_${RUN_NAME}/${TASK_NAME} ++data.name=${TASK_NAME} 

#stft large pretrained finetune
RUN_NAME=stft_large_pretrained_finetune
python3 -m testing.run_fewshot_training_tests +exp=finetune +data=finetuning_template +model=finetune_model +task=finetune_task +criterion=finetune_criterion +preprocessor=stft ++model.upstream_ckpt=/storage/user123/self_supervised_seeg/pretrained_weights/stft_large_pretrained.pth ++data.electrodes=[${ELECTRODE}] ++data.cached_data_array=/storage/user123/self_supervised_seeg/cached_data_arrays ++data.name="onset_finetuning" ++data.train_fewshot=??? ++data.reload_caches=??? +test=fewshot_test ++test.out_dir=/storage/user123/self_supervised_seeg/fewshot_test/${RUN_NAME} ++data.subject=${SUBJECT} ++data.brain_runs=[${TRIAL}]  ++data.cache_input_features=/storage/user123/self_supervised_seeg/cached_input_features/temp_features_${RUN_NAME}/${TASK_NAME} ++data.name=${TASK_NAME} 

#superlet large pretrained finetune
RUN_NAME=superlet_large_pretrained_finetune
python3 -m testing.run_fewshot_training_tests +exp=finetune +data=finetuning_template +model=finetune_model +task=finetune_task +criterion=finetune_criterion +preprocessor=superlet ++model.upstream_ckpt=/storage/user123/self_supervised_seeg/pretrained_weights/superlet_large_pretrained.pth ++data.electrodes=[${ELECTRODE}] ++data.cached_data_array=/storage/user123/self_supervised_seeg/cached_data_arrays ++data.name="onset_finetuning" ++data.train_fewshot=??? ++data.reload_caches=??? +test=fewshot_test ++test.out_dir=/storage/user123/self_supervised_seeg/fewshot_test/${RUN_NAME} ++data.subject=${SUBJECT} ++data.brain_runs=[${TRIAL}]  ++data.cache_input_features=/storage/user123/self_supervised_seeg/cached_input_features/temp_features_${RUN_NAME}/${TASK_NAME} ++data.name=${TASK_NAME}
