TASK_NAME=$1
#TASK_NAME="onset_finetuning"
RELOAD_CACHES="False"

#linear wav baseline (250ms)
python3 run_tests.py +exp=feature_extract +data=finetuning_template +model=linear_wav_baseline +task=baseline_wav_task +criterion=baseline_criterion +preprocessor=wav_preprocessor ++data.cached_data_array=/storage/user123/self_supervised_seeg/cached_data_arrays ++data.name=${TASK_NAME} ++data.duration=0.25 ++data.delta=-0.125 +test=held_out_subjects ++test.out_dir=/storage/user123/self_supervised_seeg/test_outs/linear_wav_baseline_250ms/${TASK_NAME}

#linear wav baseline (5s)
python3 run_tests.py +exp=feature_extract +data=finetuning_template +model=linear_wav_baseline +task=baseline_wav_task +criterion=baseline_criterion +preprocessor=wav_preprocessor ++data.cached_data_array=/storage/user123/self_supervised_seeg/cached_data_arrays ++data.name=${TASK_NAME} +test=held_out_subjects ++test.out_dir=/storage/user123/self_supervised_seeg/test_outs/linear_wav_baseline_5s/${TASK_NAME}

#deep linear wav baseline
python3 run_tests.py +exp=feature_extract +data=finetuning_template +model=deep_linear_wav_baseline +task=baseline_wav_task +criterion=baseline_criterion +preprocessor=wav_preprocessor ++data.cached_data_array=/storage/user123/self_supervised_seeg/cached_data_arrays ++data.name=${TASK_NAME} +test=held_out_subjects ++test.out_dir=/storage/user123/self_supervised_seeg/test_outs/deep_linear_wav_baseline/${TASK_NAME}

#stft features only
RUN_NAME=stft_pooled
python3 run_tests.py +exp=feature_extract +data=finetuning_template +model=spec_pooled_model +task=feature_extract +criterion=feature_extract_criterion +preprocessor=stft_pooled_preprocessor ++data.reload_caches=${RELOAD_CACHES} ++data.cached_data_array=/storage/user123/self_supervised_seeg/cached_data_arrays ++data.cache_input_features=/storage/user123/self_supervised_seeg/cached_input_features/temp_features_${RUN_NAME}/${TASK_NAME} ++data.name=${TASK_NAME} +test=held_out_subjects ++test.out_dir=/storage/user123/self_supervised_seeg/test_outs/${RUN_NAME}/${TASK_NAME}

#superlet features only
RUN_NAME=superlet_pooled
python3 run_tests.py +exp=feature_extract +data=finetuning_template +model=spec_pooled_model +task=feature_extract +criterion=feature_extract_criterion +preprocessor=superlet_pooled_preprocessor ++data.reload_caches=${RELOAD_CACHES} ++data.cached_data_array=/storage/user123/self_supervised_seeg/cached_data_arrays ++data.cache_input_features=/storage/user123/self_supervised_seeg/cached_input_features/temp_features_${RUN_NAME}/${TASK_NAME} ++data.name=${TASK_NAME} +test=held_out_subjects ++test.out_dir=/storage/user123/self_supervised_seeg/test_outs/${RUN_NAME}/${TASK_NAME}

#stft large pretrained feature extract
RUN_NAME=stft_large_pretrained
python3 run_tests.py +exp=feature_extract +data=finetuning_template +model=feature_extract_model +task=feature_extract +criterion=feature_extract_criterion +preprocessor=stft_pretrained ++preprocessor.upstream_ckpt=/storage/user123/self_supervised_seeg/pretrained_weights/stft_large_pretrained.pth ++data.reload_caches=${RELOAD_CACHES} ++data.cached_data_array=/storage/user123/self_supervised_seeg/cached_data_arrays ++data.cache_input_features=/storage/user123/self_supervised_seeg/cached_input_features/temp_features_${RUN_NAME}/${TASK_NAME} ++data.name=${TASK_NAME} +test=held_out_subjects ++test.out_dir=/storage/user123/self_supervised_seeg/test_outs/${RUN_NAME}/${TASK_NAME}

#stft large pretrained no alpha feature extract
RUN_NAME=stft_large_pretrained_no_alpha
python3 run_tests.py +exp=feature_extract +data=finetuning_template +model=feature_extract_model +task=feature_extract +criterion=feature_extract_criterion +preprocessor=stft_pretrained ++preprocessor.upstream_ckpt=/storage/user123/self_supervised_seeg/pretrained_weights/stft_large_pretrained_no_alpha.pth ++data.reload_caches=${RELOAD_CACHES} ++data.cached_data_array=/storage/user123/self_supervised_seeg/cached_data_arrays ++data.cache_input_features=/storage/user123/self_supervised_seeg/cached_input_features/temp_features_${RUN_NAME}/${TASK_NAME} ++data.name=${TASK_NAME} +test=held_out_subjects ++test.out_dir=/storage/user123/self_supervised_seeg/test_outs/${RUN_NAME}/${TASK_NAME}

#stft large pretrained no pretraining feature extract
RUN_NAME=stft_large_pretrained_no_pretraining
python3 run_tests.py +exp=feature_extract +data=finetuning_template +model=feature_extract_model +task=feature_extract +criterion=feature_extract_criterion +preprocessor=stft_pretrained ++preprocessor.upstream_ckpt=/storage/user123/self_supervised_seeg/pretrained_weights/random_large_model.pth ++data.reload_caches=${RELOAD_CACHES} ++data.cached_data_array=/storage/user123/self_supervised_seeg/cached_data_arrays ++data.cache_input_features=/storage/user123/self_supervised_seeg/cached_input_features/temp_features_${RUN_NAME}/${TASK_NAME} ++data.name=${TASK_NAME} +test=held_out_subjects ++test.out_dir=/storage/user123/self_supervised_seeg/test_outs/${RUN_NAME}/${TASK_NAME}

#superlet large pretrained feature extract
RUN_NAME=superlet_large_pretrained
python3 run_tests.py +exp=feature_extract +data=finetuning_template +model=feature_extract_model +task=feature_extract +criterion=feature_extract_criterion +preprocessor=superlet_pretrained ++preprocessor.upstream_ckpt=/storage/user123/self_supervised_seeg/pretrained_weights/superlet_large_pretrained.pth ++data.reload_caches=${RELOAD_CACHES} ++data.cached_data_array=/storage/user123/self_supervised_seeg/cached_data_arrays ++data.cache_input_features=/storage/user123/self_supervised_seeg/cached_input_features/temp_features_${RUN_NAME}/${TASK_NAME} ++data.name=${TASK_NAME} +test=held_out_subjects ++test.out_dir=/storage/user123/self_supervised_seeg/test_outs/${RUN_NAME}/${TASK_NAME}

#superlet large pretrained with no alpha feature extract
RUN_NAME=superlet_large_pretrained_no_alpha
python3 run_tests.py +exp=feature_extract +data=finetuning_template +model=feature_extract_model +task=feature_extract +criterion=feature_extract_criterion +preprocessor=superlet_pretrained ++preprocessor.upstream_ckpt=/storage/user123/self_supervised_seeg/pretrained_weights/superlet_large_pretrained_no_alpha.pth ++data.reload_caches=${RELOAD_CACHES} ++data.cached_data_array=/storage/user123/self_supervised_seeg/cached_data_arrays ++data.cache_input_features=/storage/user123/self_supervised_seeg/cached_input_features/temp_features_${RUN_NAME}/${TASK_NAME} ++data.name=${TASK_NAME} +test=held_out_subjects ++test.out_dir=/storage/user123/self_supervised_seeg/test_outs/${RUN_NAME}/${TASK_NAME}

#superlet large pretrained with no pretraining feature extract
RUN_NAME=superlet_large_pretrained_no_pretraining
python3 run_tests.py +exp=feature_extract +data=finetuning_template +model=feature_extract_model +task=feature_extract +criterion=feature_extract_criterion +preprocessor=superlet_pretrained ++preprocessor.upstream_ckpt=/storage/user123/self_supervised_seeg/pretrained_weights/random_large_model.pth ++data.reload_caches=${RELOAD_CACHES} ++data.cached_data_array=/storage/user123/self_supervised_seeg/cached_data_arrays ++data.cache_input_features=/storage/user123/self_supervised_seeg/cached_input_features/temp_features_${RUN_NAME}/${TASK_NAME} ++data.name=${TASK_NAME} +test=held_out_subjects  ++test.out_dir=/storage/user123/self_supervised_seeg/test_outs/${RUN_NAME}/${TASK_NAME}

#superlet large pretrained with no variable mask feature extract
RUN_NAME=superlet_large_pretrained_no_variable_mask
python3 run_tests.py +exp=feature_extract +data=finetuning_template +model=feature_extract_model +task=feature_extract +criterion=feature_extract_criterion +preprocessor=superlet_pretrained ++preprocessor.upstream_ckpt=/storage/user123/self_supervised_seeg/pretrained_weights/superlet_large_pretrained_no_variable_mask.pth ++data.reload_caches=${RELOAD_CACHES} ++data.cached_data_array=/storage/user123/self_supervised_seeg/cached_data_arrays ++data.cache_input_features=/storage/user123/self_supervised_seeg/cached_input_features/temp_features_${RUN_NAME}/${TASK_NAME} ++data.name=${TASK_NAME} +test=held_out_subjects ++test.out_dir=/storage/user123/self_supervised_seeg/test_outs/${RUN_NAME}/${TASK_NAME}

#stft large pretrained no pretraining (finetuning)
RUN_NAME=stft_large_pretrained_finetuning_no_pretraining
FEATURE=stft
python3 run_tests.py +exp=finetune +data=finetuning_template +model=finetune_model +task=finetune_task +criterion=finetune_criterion +preprocessor=stft ++model.upstream_ckpt=/storage/user123/self_supervised_seeg/pretrained_weights/random_large_model.pth ++data.reload_caches=${RELOAD_CACHES} ++data.cached_data_array=/storage/user123/self_supervised_seeg/cached_data_arrays ++data.cache_input_features=/storage/user123/self_supervised_seeg/cached_input_features/temp_features_finetune_${FEATURE} ++data.name=${TASK_NAME} +test=held_out_subjects ++test.out_dir=/storage/user123/self_supervised_seeg/test_outs/${RUN_NAME}/${TASK_NAME}

#stft large pretrained (finetuning)
RUN_NAME=stft_large_pretrained_finetuning
FEATURE=stft
python3 run_tests.py +exp=finetune +data=finetuning_template +model=finetune_model +task=finetune_task +criterion=finetune_criterion +preprocessor=stft ++model.upstream_ckpt=/storage/user123/self_supervised_seeg/pretrained_weights/stft_large_pretrained.pth ++data.reload_caches=${RELOAD_CACHES} ++data.cached_data_array=/storage/user123/self_supervised_seeg/cached_data_arrays ++data.cache_input_features=/storage/user123/self_supervised_seeg/cached_input_features/temp_features_finetune_${FEATURE} ++data.name=${TASK_NAME} +test=held_out_subjects ++test.out_dir=/storage/user123/self_supervised_seeg/test_outs/${RUN_NAME}/${TASK_NAME}

#stft large pretrained no alpha (finetuning)
RUN_NAME=stft_large_pretrained_finetuning_no_alpha
FEATURE=stft
python3 run_tests.py +exp=finetune +data=finetuning_template +model=finetune_model +task=finetune_task +criterion=finetune_criterion +preprocessor=stft ++model.upstream_ckpt=/storage/user123/self_supervised_seeg/pretrained_weights/stft_large_pretrained_no_alpha.pth ++data.reload_caches=${RELOAD_CACHES} ++data.cached_data_array=/storage/user123/self_supervised_seeg/cached_data_arrays ++data.cache_input_features=/storage/user123/self_supervised_seeg/cached_input_features/temp_features_finetune_${FEATURE} ++data.name=${TASK_NAME} +test=held_out_subjects ++test.out_dir=/storage/user123/self_supervised_seeg/test_outs/${RUN_NAME}/${TASK_NAME}

#superlet large pretrained (finetuning)
RUN_NAME=superlet_large_pretrained_finetuning
FEATURE=superlet
python3 run_tests.py +exp=finetune +data=finetuning_template +model=finetune_model +task=finetune_task +criterion=finetune_criterion +preprocessor=superlet ++model.upstream_ckpt=/storage/user123/self_supervised_seeg/pretrained_weights/superlet_large_pretrained.pth ++data.reload_caches=${RELOAD_CACHES} ++data.cached_data_array=/storage/user123/self_supervised_seeg/cached_data_arrays ++data.cache_input_features=/storage/user123/self_supervised_seeg/cached_input_features/temp_features_finetune_${FEATURE} ++data.name=${TASK_NAME} +test=held_out_subjects ++test.out_dir=/storage/user123/self_supervised_seeg/test_outs/${RUN_NAME}/${TASK_NAME}

#superlet large pretrained (finetuning) with no variable mask
RUN_NAME=superlet_large_pretrained_finetuning_no_variable_mask
FEATURE=superlet
python3 run_tests.py +exp=finetune +data=finetuning_template +model=finetune_model +task=finetune_task +criterion=finetune_criterion +preprocessor=superlet ++model.upstream_ckpt=/storage/user123/self_supervised_seeg/pretrained_weights/superlet_large_pretrained_no_variable_mask.pth ++data.reload_caches=${RELOAD_CACHES} ++data.cached_data_array=/storage/user123/self_supervised_seeg/cached_data_arrays ++data.cache_input_features=/storage/user123/self_supervised_seeg/cached_input_features/temp_features_finetune_${FEATURE} ++data.name=${TASK_NAME} +test=held_out_subjects ++test.out_dir=/storage/user123/self_supervised_seeg/test_outs/${RUN_NAME}/${TASK_NAME}

#superlet large pretrained (finetuning) with no alpha
RUN_NAME=superlet_large_pretrained_finetuning_no_alpha
FEATURE=superlet
python3 run_tests.py +exp=finetune +data=finetuning_template +model=finetune_model +task=finetune_task +criterion=finetune_criterion +preprocessor=superlet ++model.upstream_ckpt=/storage/user123/self_supervised_seeg/pretrained_weights/superlet_large_pretrained_no_alpha.pth ++data.reload_caches=${RELOAD_CACHES} ++data.cached_data_array=/storage/user123/self_supervised_seeg/cached_data_arrays ++data.cache_input_features=/storage/user123/self_supervised_seeg/cached_input_features/temp_features_finetune_${FEATURE} ++data.name=${TASK_NAME} +test=held_out_subjects ++test.out_dir=/storage/user123/self_supervised_seeg/test_outs/${RUN_NAME}/${TASK_NAME}

#superlet large pretrained (finetuning) with no pretraining
RUN_NAME=superlet_large_pretrained_finetuning_no_pretraining
FEATURE=superlet
python3 run_tests.py +exp=finetune +data=finetuning_template +model=finetune_model +task=finetune_task +criterion=finetune_criterion +preprocessor=superlet ++model.upstream_ckpt=/storage/user123/self_supervised_seeg/pretrained_weights/random_large_model.pth ++data.reload_caches=${RELOAD_CACHES} ++data.cached_data_array=/storage/user123/self_supervised_seeg/cached_data_arrays ++data.cache_input_features=/storage/user123/self_supervised_seeg/cached_input_features/temp_features_finetune_${FEATURE} ++data.name=${TASK_NAME} +test=held_out_subjects ++test.out_dir=/storage/user123/self_supervised_seeg/test_outs/${RUN_NAME}/${TASK_NAME}

#superlet large pretrained (finetuning) m00183 only
RUN_NAME=superlet_large_pretrained_finetuning_m00183_only
FEATURE=superlet
python3 run_tests.py +exp=finetune +data=finetuning_template +model=finetune_model +task=finetune_task +criterion=finetune_criterion +preprocessor=superlet ++model.upstream_ckpt=/storage/user123/self_supervised_seeg/pretrained_weights/superlet_large_pretrained.pth ++data.reload_caches=${RELOAD_CACHES} ++data.cached_data_array=/storage/user123/self_supervised_seeg/cached_data_arrays ++data.cache_input_features=/storage/user123/self_supervised_seeg/cached_input_features/temp_features_finetune_${FEATURE} ++data.name=${TASK_NAME} +test=held_out_subjects ++test.out_dir=/storage/user123/self_supervised_seeg/test_outs/${RUN_NAME}/${TASK_NAME} ++test.test_electrodes_path=/storage/user123/self_supervised_seeg/linear_results_m00183

#superlet large pretrained with no m00183 (finetuning) m00183 only
RUN_NAME=superlet_large_pretrained_no_m00183_finetuning_m00183_only
FEATURE=superlet
python3 run_tests.py +exp=finetune +data=finetuning_template +model=finetune_model +task=finetune_task +criterion=finetune_criterion +preprocessor=superlet ++model.upstream_ckpt=/storage/user123/self_supervised_seeg/pretrained_weights/superlet_large_pretrained_no_m00183.pth ++data.reload_caches=${RELOAD_CACHES} ++data.cached_data_array=/storage/user123/self_supervised_seeg/cached_data_arrays ++data.cache_input_features=/storage/user123/self_supervised_seeg/cached_input_features/temp_features_finetune_${FEATURE} ++data.name=${TASK_NAME} +test=held_out_subjects ++test.out_dir=/storage/user123/self_supervised_seeg/test_outs/${RUN_NAME}/${TASK_NAME} ++test.test_electrodes_path=/storage/user123/self_supervised_seeg/linear_results_m00183
