# BrainBERT

BrainBERT is an modeling approach for learning self-supervised representations of intracranial electrode data.

The data for this project will be released to the public, but is not included in the zip file. So most of the code that depends on this data will not run. But, for completion, we provide the training and fine-tuning pipeline instructions.

## Input
It is expected that the input is intracranial electrode data that has been Laplacian re-referenced.

## BrainBERT pre-training
```
python3 run_train.py +exp=spec2vec ++exp.runner.device=cuda ++exp.runner.multi_gpu=True ++exp.runner.num_workers=64 +data=masked_spec +model=masked_tf_model_large +data.data=/storage/user123/self_supervised_seeg/pretrain_data/manifests ++data.val_split=0.01 +task=fixed_mask_pretrain.yaml +criterion=pretrain_masked_criterion +preprocessor=stft ++data.test_split=0.01 ++task.freq_mask_p=0.05 ++task.time_mask_p=0.05 ++exp.runner.total_steps=500000
```

## Get BrainBERT test performance with finetuning on the sentence onset task
```
python3 run_tests.py +exp=finetune +data=finetuning_template +model=finetune_model +task=finetune_task +criterion=finetune_criterion +preprocessor=superlet ++model.upstream_ckpt=/storage/user123/self_supervised_seeg/pretrained_weights/superlet_large_pretrained.pth ++data.reload_caches=True ++data.name=onset_finetuning +test=held_out_subjects
```

## Get BrainBERT test performance with no-finetuning on the sentence onset task
```
python3 run_tests.py +exp=feature_extract +data=finetuning_template +model=feature_extract_model +task=feature_extract +criterion=feature_extract_criterion +preprocessor=superlet_pretrained ++preprocessor.upstream_ckpt=/storage/user123/self_supervised_seeg/pretrained_weights/superlet_large_pretrained.pth ++data.reload_caches=True ++data.name=onset_finetuning +test=held_out_subjects 
```
