# Standard Imports
import json

# App Imports
from src.subjects.dt.generation.prompts import prompts
from src.subjects.dt.samples.blood.parameters import get_blood_dataset_params_gen
from src.subjects.dt.samples.car.parameters import get_car_dataset_params_gen
from src.subjects.dt.samples.diabetes.parameters import get_diabetes_dataset_params_gen

# Verbalization to use
verbalization_id = -1


def get_verbalization(verb_id, logfile):
    with open(logfile, "r") as infile:
        verb_logs = json.load(infile)

    verbalized_difference = verb_logs[verb_id].get("response")
    return verbalized_difference


def get_generation_variables(dataset, level=None):
    system_prompt = prompts["system_prompts"][0]
    user_prompt = prompts["user_prompts"][1]

    if dataset == "blood":
       dataset_parameters = get_blood_dataset_params_gen()
    elif dataset == "car":
       dataset_parameters = get_car_dataset_params_gen()
    elif dataset == "diabetes":
        dataset_parameters = get_diabetes_dataset_params_gen()
    else:
        pass

    logfile = dataset_parameters.get("logfile")
    verbalization = get_verbalization(verbalization_id, logfile)

    variables = {
        "system_prompt": system_prompt,
        "user_prompt": user_prompt,
        "dataset_parameters": dataset_parameters,
        "verbalization_id": verbalization_id,
        "verbalization": verbalization,
    }

    return variables