# App Imports
from src.subjects.log_reg.samples.blood.level_3 import (
    gen_data,
    gen_data_pruned,
    verb_data,
)
from src.subjects.log_reg.structures.blood.level_3 import (
    model_1 as model1_struct,
    model_2 as model2_struct,
)


# Blood Dataset
blood_dataset_name = "Blood"
blood_dataset_label = "blood_level_5"
blood_dataset_sample_gen = gen_data
blood_dataset_sample_gen_pruned = gen_data_pruned
blood_dataset_sample_verb = verb_data
blood_dataset_model_info = f"The coefficients of the two logistic regression models, in the same order as the features described above, are:\nModel 1: {model1_struct}\nModel 2: {model2_struct}"

blood_dataset_description_verb = """The dataset contains details about random donors at a Blood Transfusion Service. The 4 features that it contains, in order, are: Recency (months), Frequency (times), Monetary (c.c. blood) and Time (months). The target feature (Blood Donated) is a binary variable representing whether the donor donated blood in March 2007 (1 stands for donating blood; 0 stands for not donating blood). 

The dataset below contains a sample which includes the 4 input features in the order mentioned above as well as the outputs/predictions generated by each of the two LR models."""

blood_dataset_description_gen = """The dataset contains details about random donors at a Blood Transfusion Service. The 4 features that it contains, in order, are: Recency (months), Frequency (times), Monetary (c.c. blood) and Time (months). The target feature (Blood Donated) is a binary variable representing whether the donor donated blood in March 2007 (1 stands for donating blood; 0 stands for not donating blood). 

The dataset below contains a sample which includes the 4 input features in the order mentioned above as well as outputs/predictions generated by Model 1."""

blood_dataset_description_verb_agnostic = """The dataset contains details about random donors at a Blood Transfusion Service. The 4 features that it contains, in order, are: Recency (months), Frequency (times), Monetary (c.c. blood) and Time (months). The target feature (Blood Donated) is a binary variable representing whether the donor donated blood in March 2007 (1 stands for donating blood; 0 stands for not donating blood). 

The dataset below contains a sample which includes the 4 input features in the order mentioned above as well as the outputs/predictions generated by each of the two models."""


def get_blood_dataset_params_verb(level=None):
    blood_dataset_sample = blood_dataset_sample_verb

    blood_dataset_params = {
        "dataset_name": blood_dataset_name,
        "dataset_label": blood_dataset_label,
        "dataset_sample": blood_dataset_sample,
        "dataset_description": blood_dataset_description_verb_agnostic,
        "model_info": blood_dataset_model_info,
        "logfile": "./src/subjects/log_reg/logs/blood/level5/logs.json",
    }

    return blood_dataset_params


def get_blood_dataset_params_gen(level=None):
    blood_dataset_sample = blood_dataset_sample_gen_pruned
    blood_dataset_evaluation_sample = blood_dataset_sample_gen

    blood_dataset_params = {
        "dataset_name": blood_dataset_name,
        "dataset_label": blood_dataset_label,
        "dataset_sample": blood_dataset_sample,
        "dataset_evaluation_sample": blood_dataset_evaluation_sample,
        "dataset_description": blood_dataset_description_gen,
        "logfile": "./src/subjects/log_reg/logs/blood/level5/logs.json",
    }

    return blood_dataset_params
