# App Imports
from src.subjects.log_reg.samples.blood.parameters import get_blood_dataset_params_verb
from src.subjects.log_reg.samples.car.parameters import get_car_dataset_params_verb
from src.subjects.log_reg.samples.diabetes.parameters import get_diabetes_dataset_params_verb
from src.subjects.log_reg.verbalization.prompts import prompts


def get_verbalization_variables(dataset, level=None):
    system_prompt = prompts["system_prompts"][0]
    user_prompt = prompts["user_prompts"][5]

    if dataset == "blood":
       dataset_parameters = get_blood_dataset_params_verb()
    elif dataset == "car":
        dataset_parameters = get_car_dataset_params_verb()
    elif dataset == "diabetes":
        dataset_parameters = get_diabetes_dataset_params_verb()
    else:
        pass

    system_prompt = system_prompt.format(**dataset_parameters)
    user_prompt = user_prompt.format(**dataset_parameters)

    variables = {
        "system_prompt": system_prompt,
        "user_prompt": user_prompt,
        "dataset_parameters": dataset_parameters
    }
    
    return variables