# Language Model Manager

## Overview

The Language Model Manager (LLM) is a Python script designed to interface with different Language Models (LMs) for various evaluation tasks. This script allows users to specify the LM and subject model to evaluate, and then interacts with the selected LM to obtain responses based on the provided parameters.

## Usage

### Prerequisites

Before using the LLM Manager, ensure you install the dependecies

```bash
pip install -r requirements.txt
```

### Environment Configuration
Before running the project, create a .env file in the root directory and add your OpenAI API key as follows:
```bash
OPENAI_API_KEY=your_openai_api_key_here
```

### Running the Script
To run the LLM script, use the following command:

```bash
python lm_manager.py --llm [LM_name] --subject [subject_name]
```

Replace `[LM_name]` with the name of the Language Model you want to use (e.g., GPT-3, GPT-4, Claude), and `[subject_name]` with the subject model you want to evaluate (e.g., logistic_regression, decision_tree etc)

