# Standard Imports
import argparse

# Lib Imports
from dotenv import load_dotenv

# Load Dotenv - Important to load it here so that it's part of the main.py process
load_dotenv()

# App Imports
from src.constants import LLM, ModelType, Task, Dataset
from src.task_manager import TaskManager, GenerationManager


def parse_arguments():
    """Parse command-line arguments."""
    parser = argparse.ArgumentParser(description="Description of your script")
    parser.add_argument(
        "--llm",
        help="Specify the LLM to use for evaluation",
        choices=[llm.value for llm in LLM],
        required=True,
    )
    parser.add_argument(
        "--model",
        help="Specify the model type",
        choices=[model.value for model in ModelType],
        required=True,
    )
    parser.add_argument(
        "--task",
        help="Specify the task to call",
        choices=[task.value for task in Task],
        required=True,
    )
    parser.add_argument(
        "--dataset",
        help="Specify the dataset to use",
        choices=[dataset.value for dataset in Dataset]
    )
    return parser.parse_args()


def main():
    """Main function."""
    args = parse_arguments()

    # Call TaskManager with provided arguments
    TaskManager.process(llm=args.llm, model_type=args.model, task=args.task, dataset=args.dataset)

if __name__ == "__main__":
    main()
