# Standard Imports
import json
from datetime import datetime

# App Imports
""" from src.constants import VARIABLES, EVAL_GENERATION

class VerbalizationPromptManager:
    def __init__(self, llm, subject, task):
        self.llm = llm
        self.subject = subject
        self.task = task
        self.variables = VARIABLES[self.subject][self.task]

    def get_system_prompt(self):
        system_prompt = self.variables.get("system_prompt")
        return system_prompt.format(**self.variables.get("parameters"))

    def get_query_prompt(self):
        query_prompt = self.variables.get("query_prompt")
        return query_prompt.format(**self.variables.get("parameters"))

    def log_response(self, response, important):
        logfile_path = self.variables.get("logfile")
        dataset_label = self.variables.get("parameters").get("dataset_label")

        # First, read the existing logs
        with open(logfile_path, "r") as logfile:
            logs = json.load(logfile)
        
        # Add the new log entry
        id = len(logs)
        log = {
            "id": id,
            "date": datetime.now().isoformat(),
            "llm": self.llm,
            "models": self.subject,
            "task": self.task,
            "dataset_label": dataset_label,
            "system_prompt": self.get_system_prompt(),
            "query_prompt": self.get_query_prompt(),
            "response": response,
            "important": important,
            "generation_logs": []
       }
        logs.append(log)
        
        # Write the updated logs back to the file in "w" mode
        with open(logfile_path, "w") as logfile:
            json.dump(logs, logfile, indent=4)



class GenerationPromptManager:
    def __init__(self, llm, task, subject):
        self.llm = llm
        self.subject = subject
        self.task = task
        self.variables = VARIABLES[self.subject][self.task]

    def get_system_prompt(self):
        system_prompt = self.variables.get("system_prompt")
        return system_prompt.format(**self.variables.get("parameters"))

    def get_query_prompt(self):
        query_prompt = self.variables.get("query_prompt")
        return query_prompt.format(**self.variables.get("parameters"))

    def get_evaluation_score(self, response):
        eval_scores = EVAL_GENERATION[self.subject](response).get_evaluation_scores()
        print(eval_scores)
        return eval_scores

    def log_response(self, response, important):
        logfile_path = self.variables.get("logfile")
        verb_id = self.variables.get("parameters").get("verbalization_id")
        dataset_label = self.variables.get("parameters").get("dataset_label")

        # First, read the existing logs
        with open(logfile_path, "r") as logfile:
            verb_logs = json.load(logfile)

        verb = verb_logs[verb_id]

        gen_logs = verb.get("generation_logs")

        # Add the new log entry
        id = len(gen_logs)
        log = {
            "id": id,
            "date": datetime.now().isoformat(),
            "llm": self.llm,
            "models": self.subject,
            "task": self.task,
            "dataset_label": dataset_label,
            "system_prompt": self.get_system_prompt(),
            "query_prompt": self.get_query_prompt(),
            "important": important,
            "response": response,
            "evaluation_scores": self.get_evaluation_score(response),
        }
        gen_logs.append(log)
        
        # Write the updated logs back to the file in "w" mode
        with open(logfile_path, "w") as logfile:
            json.dump(verb_logs, logfile, indent=4) """