from src.subjects.dt.samples.diabetes.level_4 import (
    gen_data,
    gen_data_pruned,
    verb_data,
)
from src.subjects.dt.structures.diabetes.level_3 import (
    model1 as model1_struct,
    model2 as model2_struct,
)


# Diabetes Dataset
diabetes_dataset_name = "Diabetes"
diabetes_dataset_sample_gen = gen_data
diabetes_dataset_label = "diabetes_level_5"
diabetes_dataset_sample_gen_pruned = gen_data_pruned
diabetes_dataset_sample_verb = verb_data
diabetes_dataset_model_info = f"The textual representations of the structures of the two decision tree models are:\nModel 1: {model1_struct} \n\n Model 2: {model2_struct}"

diabetes_dataset_description_verb = """The objective of the dataset is to diagnostically predict whether or not a patient has diabetes, based on certain diagnostic measurements. The 8 features that it contains, in order, are: Pregnancies, Glucose, BloodPressure, SkinThickness, Insulin, BMI, DiabetesPedigreeFunction and Age. The target variable (Outcome) is a binary variable representing whether the patient has diabetes (1 stands for diabetic, 0 stands for non-diabetic)

The dataset below contains a sample which includes the 8 input features in the order mentioned above, along with the outputs/predictions generated by each of the two decision tree models"""

diabetes_dataset_description_gen = """The objective of the dataset is to diagnostically predict whether or not a patient has diabetes, based on certain diagnostic measurements. The 8 features that it contains, in order, are: Pregnancies, Glucose, BloodPressure, SkinThickness, Insulin, BMI, DiabetesPedigreeFunction and Age. The target variable (Outcome) is a binary variable representing whether the patient has diabetes (1 stands for diabetic, 0 stands for non-diabetic)

The dataset below contains a sample which includes the 8 input features in the order mentioned above, along with the outputs/predictions generated by Model 1"""


def get_diabetes_dataset_params_verb(level=None):
    diabetes_dataset_sample = diabetes_dataset_sample_verb

    diabetes_dataset_params = {
        "dataset_name": diabetes_dataset_name,
        "dataset_label": diabetes_dataset_label,
        "dataset_sample": diabetes_dataset_sample,
        "dataset_description": diabetes_dataset_description_verb,
        "model_info": diabetes_dataset_model_info,
        "logfile": "./src/subjects/dt/logs/diabetes/level5/logs.json",
    }

    return diabetes_dataset_params


def get_diabetes_dataset_params_gen(level=None):
    diabetes_dataset_sample = diabetes_dataset_sample_gen_pruned
    diabetes_dataset_evaluation_sample = diabetes_dataset_sample_gen

    diabetes_dataset_params = {
        "dataset_name": diabetes_dataset_name,
        "dataset_label": diabetes_dataset_label,
        "dataset_sample": diabetes_dataset_sample,
        "dataset_evaluation_sample": diabetes_dataset_evaluation_sample,
        "dataset_description": diabetes_dataset_description_gen,
        "logfile": "./src/subjects/dt/logs/diabetes/level5/logs.json",
    }

    return diabetes_dataset_params
