# App Imports
from src.subjects.log_reg.samples.car.level_3 import (
    gen_data,
    gen_data_pruned,
    verb_data,
)
from src.subjects.log_reg.structures.car.level_3 import (
    model_1 as model1_struct,
    model_2 as model2_struct,
)


# Blood Dataset
car_dataset_name = "Car"
car_dataset_label = "car_level_5"
car_dataset_sample_gen = gen_data
car_dataset_sample_gen_pruned = gen_data_pruned
car_dataset_sample_verb = verb_data
car_dataset_model_info = (
    f"The coefficients of the two logistic regression models, in the same order as the features described above, are:\nModel 1: {model1_struct}\nModel 2: {model2_struct}"
) 
car_dataset_description_verb = """The dataset was derived from a simple hierarchical decision model developed for the evaluation of cars. The 6 features that it contains, in order, are: buying (buying price, encoding - {"vhigh":3, "high": 2, "med": 1, "low": 0}), maint (maintenance price, encoding - {"vhigh": 3, "high": 2, "med": 1, "low": 0}), doors (number of doors, encoding - {"2": 2, "3": 3, "4": 4, "5more": 5}), persons (capacity of persons, encoding - {"2": 2, "4": 4, "more": 5}), lug_boot (size of luggage boot, encoding - {"small": 0, "med": 1, "big": 2}) and safety (safety level, encoding - {"low": 0, "med": 1, "high": 2}). The target variable (class) represents the overall evaluation of the car and has four possible values: 0 (Unacceptable), 1 (Acceptable), 2 (Good), 3 (Very Good)

The dataset below contains a sample which includes the 6 input features in the order mentioned above, along with the outputs/predictions generated by each of the two LR models."""

car_dataset_description_gen = """The dataset was derived from a simple hierarchical decision model developed for the evaluation of cars. The 6 features that it contains, in order, are: buying (buying price, encoding - {"vhigh":3, "high": 2, "med": 1, "low": 0}), maint (maintenance price, encoding - {"vhigh": 3, "high": 2, "med": 1, "low": 0}), doors (number of doors, encoding - {"2": 2, "3": 3, "4": 4, "5more": 5}), persons (capacity of persons, encoding - {"2": 2, "4": 4, "more": 5}), lug_boot (size of luggage boot, encoding - {"small": 0, "med": 1, "big": 2}) and safety (safety level, encoding - {"low": 0, "med": 1, "high": 2}). The target variable (class) represents the overall evaluation of the car and has four possible values: 0 (Unacceptable), 1 (Acceptable), 2 (Good), 3 (Very Good)

The dataset below contains a sample which includes the 6 input features in the order mentioned above as well as outputs/predictions generated by Model 1"""

car_dataset_description_verb_agnostic = """The dataset was derived from a simple hierarchical decision model developed for the evaluation of cars. The 6 features that it contains, in order, are: buying (buying price, encoding - {"vhigh":3, "high": 2, "med": 1, "low": 0}), maint (maintenance price, encoding - {"vhigh": 3, "high": 2, "med": 1, "low": 0}), doors (number of doors, encoding - {"2": 2, "3": 3, "4": 4, "5more": 5}), persons (capacity of persons, encoding - {"2": 2, "4": 4, "more": 5}), lug_boot (size of luggage boot, encoding - {"small": 0, "med": 1, "big": 2}) and safety (safety level, encoding - {"low": 0, "med": 1, "high": 2}). The target variable (class) represents the overall evaluation of the car and has four possible values: 0 (Unacceptable), 1 (Acceptable), 2 (Good), 3 (Very Good)

The dataset below contains a sample which includes the 6 input features in the order mentioned above, along with the outputs/predictions generated by each of the two models."""


def get_car_dataset_params_verb(level=None):
    car_dataset_sample = car_dataset_sample_verb
    car_dataset_params = {
        "dataset_name": car_dataset_name,
        "dataset_label": car_dataset_label,
        "dataset_sample": car_dataset_sample,
        "dataset_description": car_dataset_description_verb_agnostic,
        "model_info": car_dataset_model_info,
        "logfile": "./src/subjects/log_reg/logs/car/level5/logs.json",
    }

    return car_dataset_params


def get_car_dataset_params_gen(level=None):
    car_dataset_sample = car_dataset_sample_gen_pruned
    car_dataset_evaluation_sample = car_dataset_sample_gen

    car_dataset_params = {
        "dataset_name": car_dataset_name,
        "dataset_label": car_dataset_label,
        "dataset_sample": car_dataset_sample,
        "dataset_evaluation_sample": car_dataset_evaluation_sample,
        "dataset_description": car_dataset_description_gen,
        "logfile": "./src/subjects/log_reg/logs/car/level5/logs.json",
    }

    return car_dataset_params
