# App Imports
from src.constants import ModelType, Task
from src.subjects import log_reg, dt, knn


VARIABLE_MAPPING = {
    ModelType.LogReg.value: {
        Task.Verbalization.value: log_reg.verbalization.get_verbalization_variables,
        Task.Generation.value: log_reg.generation.get_generation_variables,
    },
    ModelType.DT.value: {
        Task.Verbalization.value: dt.verbalization.get_verbalization_variables,
        Task.Generation.value: dt.generation.get_generation_variables,
    },
    ModelType.KNN.value: {
        Task.Verbalization.value: knn.verbalization.get_verbalization_variables,
        Task.Generation.value: knn.generation.get_generation_variables,
    },
}

EVALUATION_MAPPING = {
    ModelType.LogReg.value: log_reg.evaluation.Evaluation,
    ModelType.DT.value: dt.evaluation.Evaluation,
    ModelType.KNN.value: knn.evaluation.Evaluation
}
