
'''
resample wav to 16000.
path:original folder of your dataset
result_path: target folder of resampling wav
'''


import librosa
import os
path = '/home/ttsdev/nastts/VCTK-Corpus'
result_path = '/home/ttsdev/nastts/resample_wav'
listdir = os.listdir(path)
for spkfolder in listdir:
    if os.path.isdir(os.path.join(path, spkfolder)):
        print("processing speaker ", spkfolder)
        wavlist = os.listdir(os.path.join(path, spkfolder))
        for wav in wavlist:
            y, sr = librosa.load(os.path.join(path,spkfolder,wav), sr=None)
            print("original sampling rate:", sr)
            y_resample = librosa.resample(y, sr, 16000)
            os.makedirs(os.path.join(result_path, spkfolder), exist_ok=True)
            librosa.output.write_wav(os.path.join(result_path, spkfolder, wav), y_resample,16000)