
import torch
import librosa
import pickle
from synthesis import build_model
from synthesis import wavegen
import numpy as np
import os
import pyworld
source_speaker = 'p261'
target_speaker = 'p268'
spect_vc = pickle.load(open('results.pkl', 'rb'))
device = torch.device("cuda")
model = build_model().to(device)
checkpoint = torch.load("checkpoint_step001000000_ema.pth")
model.load_state_dict(checkpoint["state_dict"])

for spect in spect_vc:
    name = spect[0]
    if ("{}x{}".format(source_speaker, target_speaker) == spect[0]):
        print("find it:", spect[1].shape)
        mel_lens = spect[1].shape[0]
        c = spect[1]
        print("test c:", c.shape)
        print(c)
        print(name)
        waveform = wavegen(model, c=c)
        librosa.output.write_wav(name+'.wav', waveform, sr=44100)
