# Learning Better Certified Models from Empirically-Robust Teachers

The present supplementary material is associated with the submission titled "*Learning Better Certified Models from Empirically-Robust Teachers*".
Code is provided in the `cc-dist` folder.

## Installation

In order to execute the code, please follow the instructions below.

```
# Create a conda environment
conda create -n cc-dist python=3.8 'setuptools<70.0'
conda activate cc-dist

# install pytorch and torchvision: see https://pytorch.org/get-started/
conda install pytorch==1.11.0 torchvision==0.12.0 cudatoolkit=11.3 -c pytorch
```

We now provide instructions to install code dependencies that require a manual installation: 
```
# install the April 2024 auto_LiRPA release from source: see https://github.com/KaidiXu/auto_LiRPA
git clone https://github.com/KaidiXu/auto_LiRPA.git
cd auto_LiRPA
git reset --hard bfb7997115c5e66327de81b43c42b23c8a0ffb1e
pip install .
cd ..

# install the OVAL branch-and-bound framework: see https://github.com/oval-group/oval-bab
git clone https://github.com/oval-group/oval-bab.git
cd oval-bab
pip install .
cd ..
```

Finally, the present code can be installed as follows:
```
cd cc-dist
pip install .
```

## Downloading datasets

TinyImageNet and downscaled ImageNet require the execution of scripts before running the code, with instructions provided below.
The downscaled ImageNet script additionally assumes that the raw images (Train and Val, 64x64, npz format, which can be found under the "Download downsampled image data (32x32, 64x64)" section) 
have already been downloaded from [Image-Net.org](http://image-net.org/download-images) and decompressed (e.g., into `imagenet_folder`).
CIFAR-10 is instead automatically downloaded within the code through `torchvision`. 

```
# TinyImageNet scripts
cd data/tinyimagenet
bash tinyimagenet_download.sh
cd ..

# downscaled ImageNet scripts
cd data/ImageNet64
python imagenet_data_loader.py --folder imagenet_folder_path
cd ..
```

## Execution logs and models

Execution logs can be found in the `logs` and `verification_logs` folders for training and verification jobs, respectively.
The training log contains the path to the model (needed to use it as teacher, and to verification on it) within the `"model_dir"` entry of the `"summary"` sub-dictionary.
Note that for ease of implementation, the models to be used as teachers use a different model function.
Models are saved into the directory indicated by the `--dir` argument: we will use `model_<dataset>` in the scripts below.


## Reproducing the main results

We here provide commands to reproduce the experiments in Table 1. 
If operating on newer Nvidia GPUs, we recommend adding the `--disable_train_tf32` flag to the training jobs.

### CIFAR10 - 2/255

```
mkdir -p model_cifar
# CC-Dist teacher
python train.py --method=fast --dir=model_cifar --scheduler_opts=start=2,length=1 --num-epochs=30 --config=config/cifar_2_255.json --model=cnn7_teacher --train_att_n_steps 10 --train_att_step_size 0.25 --test_att_n_steps 40 --test_att_step_size 0.1 --l1_coeff 1e-5 --reg-lambda 0.0 --pure_adv --test-interval 3 --lr-step batch --lr-schedule cyclic --opt SGD
# CC-Dist
python train.py --method=fast --dir=model_cifar --scheduler_opts=start=2,length=80 --lr-decay-milestones=120,140 --num-epochs=160 --config=config/cifar_2_255.json --model=cnn --test_att_n_steps 40 --test_att_step_size 0.1 --test-interval 20 --ccdist --ccibp_coeff 1e-2 --distillation_coeff 5e0 --train_att_n_steps 8 --train_att_step_size 0.25 --l1_coeff 3e-6 --attack_eps_factor 2.1 --teacher_path ./teacher_path --teacher_model=cnn7_teacher 
# CC-IBP baseline
python train.py --method=fast --dir=model_cifar --scheduler_opts=start=2,length=80 --lr-decay-milestones=120,140 --num-epochs=160 --config=config/cifar_2_255.json --model=cnn --test_att_n_steps 40 --test_att_step_size 0.1 --test-interval 20 --ccdist --ccibp_coeff 1e-2 --distillation_coeff 0.0 --train_att_n_steps 8 --train_att_step_size 0.25 --l1_coeff 3e-6 --attack_eps_factor 2.1 --teacher_path ./teacher_path --teacher_model=cnn7_teacher
# Model verification
python verify.py --config=config/cifar_2_255.json --model=cnn --ib_batch_size 2000 --oval_bab_config ./bab_configs/cnn7_naive.json --oval_bab_timeout 600 --load ./trained_model_path --test_att_n_steps 40 --test_att_step_size 0.1
```

### CIFAR10 - 8/255

```
mkdir -p model_cifar
# CC-Dist teacher
python train.py --method=fast --dir=model_cifar --scheduler_opts=start=2,length=1 --num-epochs=30 --config=config/cifar.json --model=cnn7_teacher --train_att_n_steps 10 --train_att_step_size 0.25 --test_att_n_steps 40 --test_att_step_size 0.1 --l1_coeff 5e-6 --reg-lambda 0.0 --pure_adv --test-interval 3 --lr-step batch --lr-schedule cyclic --opt SGD
# CC-Dist
python train.py --method=fast --dir=model_cifar --scheduler_opts=start=2,length=80 --lr-decay-milestones=180,220 --num-epochs=260 --config=config/cifar.json --model=cnn --test_att_n_steps 40 --test_att_step_size 0.1 --test-interval 20 --ccdist --ccibp_coeff 0.5 --distillation_coeff 5e0 --train_att_n_steps 1 --train_att_step_size 10.0 --l1_coeff 0 --teacher_path ./teacher_path --teacher_model=cnn7_teacher  
# CC-IBP baseline
python train.py --method=fast --dir=model_cifar --scheduler_opts=start=2,length=80 --lr-decay-milestones=180,220 --num-epochs=260 --config=config/cifar.json --model=cnn --test_att_n_steps 40 --test_att_step_size 0.1 --test-interval 20 --ccdist --ccibp_coeff 0.5 --distillation_coeff 0.0 --train_att_n_steps 1 --train_att_step_size 10.0 --l1_coeff 0 --teacher_path ./teacher_path --teacher_model=cnn7_teacher
# Model verification
python verify.py --config=config/cifar.json --model=cnn --ib_batch_size 2000 --oval_bab_config ./bab_configs/cnn7_naive.json --oval_bab_timeout 600 --load ./trained_model_path --test_att_n_steps 40 --test_att_step_size 0.1
```

### TinyImageNet - 1/255

```
mkdir -p model_tinyimagenet
# CC-Dist teacher
python train.py --method=fast --dir=model_tinyimagenet --scheduler_opts=start=2,length=1 --num-epochs=100 --num-class 200 --batch-size=128 --config=config/tinyimagenet.ibp.json --model=cnn7_teacher_imagenet --train_att_n_steps 10 --train_att_step_size 0.25 --test_att_n_steps 40 --test_att_step_size 0.1 --test-interval 10 --l1_coeff 5e-5 --reg-lambda 0.0 --pure_adv --lr-step batch --lr-schedule cyclic --opt SGD
# CC-Dist
python train.py --method=fast --dir=model_tinyimagenet --scheduler_opts=start=2,length=80 --reg-lambda=0.2 --lr-decay-milestones=120,140 --num-epochs=160 --num-class 200 --batch-size=128 --config=config/tinyimagenet.ibp.json --model=cnn_7layer_bn_imagenet --train_att_n_steps 1 --train_att_step_size 10.0 --test_att_n_steps 40 --test_att_step_size 0.1 --test-interval 20 --l1_coeff 5e-5 --ccdist --ccibp_coeff 5e-3 --distillation_coeff 5e0 --teacher_path ./teacher_path --teacher_model=cnn7_teacher_imagenet
# CC-IBP baseline
python train.py --method=fast --dir=model_tinyimagenet --scheduler_opts=start=2,length=80 --reg-lambda=0.2 --lr-decay-milestones=120,140 --num-epochs=160 --num-class 200 --batch-size=128 --config=config/tinyimagenet.ibp.json --model=cnn_7layer_bn_imagenet --train_att_n_steps 1 --train_att_step_size 10.0 --test_att_n_steps 40 --test_att_step_size 0.1 --test-interval 20 --l1_coeff 5e-5 --ccdist --ccibp_coeff 3e-3 --distillation_coeff 0.0 --teacher_path ./teacher_path --teacher_model=cnn7_teacher_imagenet
# Model verification
python verify.py --config=config/tinyimagenet.ibp.json --model=cnn_7layer_bn_imagenet --ib_batch_size 2000 --oval_bab_config ./bab_configs/cnn7_naive_lessmem.json --oval_bab_timeout 600 --load ./trained_model_path --test_att_n_steps 40 --test_att_step_size 0.1 --num-class 200 --oval_trim_logitdiff
```

### ImageNet64 - 1/255

```
mkdir -p model_imagenet64
# CC-Dist teacher
python train.py --method=fast --dir=model_imagenet64 --scheduler_opts=start=2,length=1 --num-epochs=30 --num-class 1000 --batch-size=128 --config=config/imagenet64.json --model=cnn7_teacher_imagenet --model-params=num_class=1000,linear_size=1024 --train_att_n_steps 10 --train_att_step_size 0.25 --test_att_n_steps 40 --test_att_step_size 0.1 --test-interval 3 --data_loader_workers 6 --l1_coeff 5e-6 --reg-lambda 0.0 --pure_adv --lr-step batch --lr-schedule cyclic --opt SGD 
# CC-Dist
python train.py --method=fast --config=config/imagenet64.json --dir=model_imagenet64 --model=cnn_7layer_bn_imagenet --model-params=num_class=1000,linear_size=1024 --scheduler_opts=start=2,length=20 --reg-lambda=0.2 --lr-decay-milestones=60,70 --num-epochs=80 --num-class 1000 --batch-size=128 --train_att_n_steps 1 --train_att_step_size 10.0 --test_att_n_steps 40 --test_att_step_size 0.1 --ccdist --l1_coeff 1e-5 --ccibp_coeff 5e-3 --distillation_coeff 5e0 --teacher_path ./teacher_path --teacher_model=cnn7_teacher_imagenet --teacher-model-params=num_class=1000,linear_size=1024 --test-interval 5 --data_loader_workers 6 
# CC-IBP baseline
python train.py --method=fast --config=config/imagenet64.json --dir=model_imagenet64 --model=cnn_7layer_bn_imagenet --model-params=num_class=1000,linear_size=1024 --scheduler_opts=start=2,length=20 --reg-lambda=0.2 --lr-decay-milestones=60,70 --num-epochs=80 --num-class 1000 --batch-size=128 --train_att_n_steps 1 --train_att_step_size 10.0 --test_att_n_steps 40 --test_att_step_size 0.1 --ccdist --l1_coeff 1e-5 --ccibp_coeff 5e-3 --distillation_coeff 0.0 --teacher_path ./teacher_path --teacher_model=cnn7_teacher_imagenet --teacher-model-params=num_class=1000,linear_size=1024 --test-interval 5 --data_loader_workers 6
# Model verification. In case of memory issues, decrease lirpa_crown_batch.
python verify.py --config=config/imagenet64.json --model=cnn_7layer_bn_imagenet --model-params=num_class=1000,linear_size=1024 --ib_batch_size 2000 --oval_bab_config ./bab_configs/cnn7_naive_lessmem.json --oval_bab_timeout 600 --load ./trained_model_path --test_att_n_steps 40 --test_att_step_size 0.1 --num-class 1000 --lirpa_crown_batch 700 --oval_trim_logitdiff
```

## Reproducing the other experiments

In order to perform verification on the teachers as per Table 2, `-end_idx 500` needs to be appended to the above verification scripts in order to stop at image 500. 
Furthermore, `cnn7_naive_lessmem.json` needs to be replaced by `cnn7_naive_lessmem_crownibs.json` on TinyImageNet and ImageNet64.

Figure 3 can be reproduced by appropriately editing the `--distillation_coeff` in the scripts.

CC-Dist0 and CC-Dist1 can be respectively run by adding the `--ccdist0_dist_loss` and `--ccdist1_dist_loss` flags to the CC-Dist commands, respectively.
Analogously, the logit-space distillation scheme can be run by adding `--kl_dist_loss`.

In order to run the training experiments from Table 6, the following commands must be run:
```
# teacher
python train.py --method=fast --dir=model_tinyimagenet --scheduler_opts=start=2,length=1 --num-epochs=30 --num-class 200 --batch-size=128 --config=config/tinyimagenet.ibp.json --model=preactresnet18_teacher --train_att_n_steps 10 --train_att_step_size 0.25 --test_att_n_steps 40 --model-params=num_class=200,last_stride=4 --test_att_step_size 0.1 --test-interval 3 --l1_coeff 5e-5 --reg-lambda 0.0 --pure_adv --lr-step batch --lr-schedule cyclic --opt SGD
# student
python train.py --method=fast --dir=model_tinyimagenet --scheduler_opts=start=2,length=80 --reg-lambda=0.2 --lr-decay-milestones=120,140 --num-epochs=160 --num-class 200 --batch-size=128 --config=config/tinyimagenet.ibp.json --model=cnn_7layer_bn_imagenet --train_att_n_steps 1 --train_att_step_size 10.0 --test_att_n_steps 40 --test_att_step_size 0.1 --test-interval 20 --l1_coeff 5e-5 --ccdist --ccibp_coeff 3e-3 --distillation_coeff 5e0 --teacher_path ./teacher_path --teacher_model=preactresnet18_teacher --teacher-model-params=num_class=200,last_stride=4
```

We used seeds 0, 1 and 2 (use `--seed`) besides the default seed for the additional repetitions in appendix E.4.

## Acknowledgments
We thank [(De Palma et al., 2024)](https://github.com/alessandrodepalma/expressive-losses) and [(Shi et al., 2021)](https://github.com/shizhouxing/Fast-Certified-Robust-Training), upon which our codebase is based, for open-sourcing their code.
