import argparse

def get_parser():
    parser = argparse.ArgumentParser(formatter_class=argparse.ArgumentDefaultsHelpFormatter)
    parser.add_argument('--config', type=str, required=True)

    #experiment setting
    parser.add_argument('--gpu_ids', nargs='*', type=int)
    parser.add_argument('--omp_num_threads',    type=int)
    parser.add_argument('--save_dir',           type=str)
    parser.add_argument('--seed',               type=int)
    parser.add_argument('--use_amp',            action='store_true')
    parser.add_argument('--use_non_blocking',   action='store_true')
    # for experiment_only_eval.py
    parser.add_argument('--eval_model_file',    type=str)

    # training/inference setting
    parser.add_argument('--optimizer_name',           type=str)
    parser.add_argument('--lr',                       type=float)
    parser.add_argument('--scale_lr',                 action='store_true')
    parser.add_argument('--filter_bias_and_bn',       action='store_true')
    parser.add_argument('--momentum',                 type=float)
    parser.add_argument('--weight_decay',             type=float)
    parser.add_argument('--scheduler_name',           type=str)
    parser.add_argument('--milestones', nargs='*',    type=int)
    parser.add_argument('--gamma',                    type=float)
    parser.add_argument('--min_lr',                   type=float)
    parser.add_argument('--warmup_lr_init',           type=float)
    parser.add_argument('--warmup_t',                 type=int)
    parser.add_argument('--warmup_prefix',            action='store_true')
    parser.add_argument('--batch_size_per_gpu',       type=int)
    parser.add_argument('--batch_size_val_per_gpu',   type=int)
    parser.add_argument('--batch_size_test_per_gpu',  type=int)
    parser.add_argument('--max_epoch',                type=int)
    parser.add_argument('--eval_interval',            type=int)
    parser.add_argument('--save_interval',            type=int)
    parser.add_argument('--repeated_aug',             action='store_true')
    parser.add_argument('--mixup',                    type=float)
    parser.add_argument('--smoothing',                type=float)
    parser.add_argument('--cutmix',                   type=float)
    parser.add_argument('--cutmix_minmax', nargs='+', type=float)
    parser.add_argument('--mixup_prob',               type=float)
    parser.add_argument('--mixup_switch_prob',        type=float)
    parser.add_argument('--mixup_mode',               type=str)
    parser.add_argument('--model_ema',                action='store_true')
    parser.add_argument('--model_ema_decay',          type=float)
    parser.add_argument('--model_ema_force_cpu',      action='store_true')
    parser.add_argument('--clip_grad',                type=float)

    # model setting
    parser.add_argument('--model_name',    type=str)
    parser.add_argument('--nonlinearity',  type=str)
    parser.add_argument('--use_affine_bn', action='store_true')
    parser.add_argument('--width_factor',  type=float)
    parser.add_argument('--drop',          type=float)
    parser.add_argument('--drop_path',     type=float)
    parser.add_argument('--algo',          type=str)
    parser.add_argument('--sparsity',      type=float)
    parser.add_argument('--scale_method',  type=str)
    parser.add_argument('--w_init_method', type=str)
    parser.add_argument('--s_init_method', type=str)
    parser.add_argument('--m_init_method', type=str)
    parser.add_argument('--p_ratio',       type=float)
    parser.add_argument('--r_ratio',       type=float)
    parser.add_argument('--r_method',      type=str)
    parser.add_argument('--n_divisions',   type=int)
    parser.add_argument('--n_rewinds',     type=int)
    parser.add_argument('--fitness',       type=str)
    parser.add_argument('--mask_file',     type=str)

    # dataset setting
    parser.add_argument('--dataset_name',         type=str)
    parser.add_argument('--dataset_dir',          type=str)
    parser.add_argument('--train_val_ratio',      type=float)
    parser.add_argument('--n_worker',             type=int)
    parser.add_argument('--n_worker_eval',        type=int)
    parser.add_argument('--n_worker_test',        type=int)
    parser.add_argument('--use_simple_transform', action='store_true')
    
    return parser