## Usage
This repository provides the code to train Hierarchically Quantized VAE (HQ-VAE) on vision datasets, CIFAR10, CelebA-HQ, FFHQ, and ImageNet.
The training setup can be adjusted in the config files: default.py and *.yaml in /configs.
Before running the scrpit, you should set the following paths
- Lines 4 and 5 of config files (.yaml) for saved models, images, results etc

## Examples
Example 1. SQ-VAE-2 on CIFAR10:
```
python main.py -c "sqvae2/cifar10.yaml" --save
```
Example 2. RSQ-VAE on CIFAR10:
```
python main.py -c "rsqvae/cifar10.yaml" --save
```
Example 3. RSQ-VAE on CIFAR10 with codebook share:
```
python main.py -c "rsqvae/cifar10_codebook_share.yaml" --save
```
Example 4. Hybrid model on CelebA-HQ:
```
python main.py -c "hybrid/celebahq.yaml" --save
```
You can change experimental settings by editing the yaml files.

## List of config files
| Section | Filename |Description |
| ---- | ---- | ---- |
| Section 5.1 | sqvae2/cifar10.yaml | SQ-VAE-2 on CIFAR10 |
| Section 5.1 | sqvae2/celebahq.yaml | SQ-VAE-2 on CelebA-HQ |
| Section 5.1 | sqvae2/ffhq.yaml | SQ-VAE-2 on FFHQ |
| Section 5.1 | sqvae2/imagenet.yaml | SQ-VAE-2 on ImageNet |
| Section 5.2 | rsqvae/cifar10.yaml | RSQ-VAE on CIFAR10 |
| Section 5.2 | rsqvae/cifar10_codebook_share.yaml | RSQ-VAE (w/ codebook share) on CIFAR10 |
| Section 5.2 | rsqvae/celebahq.yaml | RSQ-VAE on CelebAHQ |
| Section 5.2 | rsqvae/celebahq_codebook_share.yaml | RSQ-VAE (w/ codebook share) on CelebA-HQ |
| Section 5.3 (Appendix C.3) | hybrid/celebahq.yaml | HQ-VAE with six layers on CelebA-HQ (case 1) |
| Section 5.3 (Appendix C.3) | hybrid/celebahq_2.yaml | HQ-VAE with seven layers on CelebA-HQ (case 2) |

## Evaluation
Example. SQ-VAE-2 on CIFAR10:
```
python eval.py -c "sqvae2/cifar10.yaml" -ts [time_stamp:seedX_mmdd_hhmm]
```