# Evaluating SGD and Adam Optimizers on a CNN Model using MNIST dataset

This project is a Python-based implementation of a Convolutional Neural Network (CNN) model with approximately 200k parameters. The model is trained and evaluated on the MNIST dataset to evaluate the performance of SGD and Adam optimizers.

## Getting Started

These instructions will get you a copy of the project up and running on your local machine for development and testing purposes.

### Prerequisites

The project requires the following packages:

- Python 3.10 or higher
- PyTorch
- torchvision
- NumPy
- scikit-learn

### Installing

A step by step series of examples that tell you how to get a development environment running.

1. Clone the repository to your local machine
2. Install the prerequisites via pip:

```bash
pip install -r requirements.txt
```

## Running the Train and Test Code

The main script is `main.py`. It can be run with command-line arguments to specify the learning rate, momentum, percentage of training data to use, and the mode (train or test).

Example usage:

```bash
python main.py --lr 0.01 --momentum 0.9 --train_size_percentage 100 --mode TRAIN
```

## Learning Rate and Momentum Combinations

The following combinations of learning rate and momentum are used to run `main.py`:

| Learning Rate | Momentum |
| ------------- | -------- |
| 0.0001        | 0.0      |
| 0.0001        | 0.2      |
| 0.0001        | 0.4      |
| 0.0001        | 0.6      |
| 0.0001        | 0.8      |
| 0.0001        | 0.825    |
| 0.0001        | 0.85     |
| 0.0001        | 0.874    |
| 0.0001        | 0.9      |
| 0.0001        | 0.925    |
| 0.001         | 0.0      |
| 0.001         | 0.2      |
| 0.001         | 0.4      |
| 0.001         | 0.6      |
| 0.001         | 0.8      |
| 0.001         | 0.825    |
| 0.001         | 0.85     |
| 0.001         | 0.874    |
| 0.001         | 0.9      |
| 0.001         | 0.925    |
| 0.01          | 0.0      |
| 0.01          | 0.2      |
| 0.01          | 0.4      |
| 0.01          | 0.6      |
| 0.01          | 0.8      |
| 0.01          | 0.825    |
| 0.01          | 0.85     |
| 0.01          | 0.874    |
| 0.01          | 0.9      |
| 0.01          | 0.925    |
| 0.016         | 0.0      |
| 0.016         | 0.2      |
| 0.016         | 0.4      |
| 0.016         | 0.6      |
| 0.016         | 0.8      |
| 0.016         | 0.825    |
| 0.016         | 0.85     |
| 0.016         | 0.874    |
| 0.016         | 0.9      |
| 0.016         | 0.925    |
| 0.1           | 0.0      |
| 0.1           | 0.2      |
| 0.1           | 0.4      |
| 0.1           | 0.6      |
| 0.1           | 0.8      |
| 0.1           | 0.825    |
| 0.1           | 0.85     |
| 0.1           | 0.874    |
| 0.1           | 0.9      |
| 0.1           | 0.925    |
| 0.2           | 0.0      |
| 0.2           | 0.2      |
| 0.2           | 0.4      |
| 0.2           | 0.6      |
| 0.2           | 0.8      |
| 0.2           | 0.825    |
| 0.2           | 0.85     |
| 0.2           | 0.874    |
| 0.2           | 0.9      |
| 0.2           | 0.925    |

Each combination is used to run `main.py` with the following command:

```bash
python main.py --lr [learning_rate] --momentum [momentum] --train_size_percentage 100 --mode TRAIN
```

## Running the Evaluation Script

The evaluation script `eval_infer_results.py` is used to process the results of different experiments, extract learning rate and momentum values from the filenames, and plot a heatmap of the results. It also highlights the top 10 and top 1 values in the heatmap. The heatmap is saved to a new folder created in the base output directory.

To run the script, follow these steps:

1. Ensure that you have completed the previous steps and have the necessary results from running `main.py`. You should have these four folders in the output directory: `adam_mnist_100`, `adam_mnist_50`, `sgd_mnist_100`, `sgd_mnist_50`

2. Navigate to the project directory in your terminal.

3. Run the following command:

```bash
python eval_infer_results.py
```
