import argparse
import json
import pdb

def process_jsonl(input_file, output_file):
    with open(input_file, 'r') as infile, open(output_file, 'w') as outfile:
        for line in infile:
            data = json.loads(line)
            trad_seq = data.get('trad', [])
            for trad in trad_seq:
                if trad.get('require_opt') == 'false':
                    # Create a new dictionary with the required fields and the correct trad fields
                    filtered_data = {
                        'question_id': data.get('question_id'),
                        'db_path': data.get('db_path'),
                        'db_id': data.get('db_id'),
                        'data_overview': data.get('data_overview'),
                        **trad
                    }
                    
                    # Write the filtered data to the output file
                    outfile.write(json.dumps(filtered_data, ensure_ascii=False) + '\n') 
                    break
                    

def main():
    parser = argparse.ArgumentParser(description="Process JSONL file to filter and extract correct trad_seq")
    parser.add_argument('--input_file', type=str, help="Path to the input JSONL file")
    parser.add_argument('--output_file', type=str, help="Path to the output JSONL file")

    args = parser.parse_args()

    process_jsonl(args.input_file, args.output_file)
    
    print('')

if __name__ == "__main__":
    main()
