import argparse
import json
import pdb

def process_jsonl_tabmwp(input_file, output_file):
    with open(input_file, 'r') as infile, open(output_file, 'w') as outfile:
        for line in infile:
            data = json.loads(line)
            trad_seq = data.get('trad', [])
            for trad in trad_seq:
                if trad.get('require_opt') == 'false':
                    # Create a new dictionary with the required fields and the correct trad fields
                    filtered_data = {
                        'question_id': data.get('question_id'),
                        'data_path': data.get('data_path'),
                        'data_title': data.get('table_title'),
                        'data_overview': data.get('data_overview'),
                        'result': data.get('result', ''),
                        'answer': data.get('answer', ''),
                        'answer_type': data.get('ans_type', ''),
                        **trad
                    }
                    
                    # Write the filtered data to the output file
                    outfile.write(json.dumps(filtered_data, ensure_ascii=False) + '\n') 
                    break
                

def process_jsonl_wiki(input_file, output_file):
    with open(input_file, 'r') as infile, open(output_file, 'w') as outfile:
        for line in infile:
            data = json.loads(line)
            trad_seq = data.get('trad', [])
            for trad in trad_seq:
                if trad.get('require_opt') == 'false':
                    # Create a new dictionary with the required fields and the correct trad fields
                    filtered_data = {
                        'question_id': data.get('question_id'),
                        'data_path': data.get('data_path'),
                        'result': data.get('result', ''),
                        'answer': data.get('answer', ''),
                        'data_overview': data.get('data_overview', ''),
                        'execution': data.get('execution', ''),
                        **trad
                    }
                    
                    # Write the filtered data to the output file
                    outfile.write(json.dumps(filtered_data, ensure_ascii=False) + '\n') 
                    break
                    

def main():
    parser = argparse.ArgumentParser(description="Process JSONL file to filter and extract correct trad_seq")
    parser.add_argument('--input_file', type=str, help="Path to the input JSONL file")
    parser.add_argument('--output_file', type=str, help="Path to the output JSONL file")

    args = parser.parse_args()

    process_jsonl_wiki(args.input_file, args.output_file)
    
    print('')

if __name__ == "__main__":
    main()
