#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Load and display results of a trained model
"""

from src import save_load_utils as sl
from src import plotting_functions as pf

ROOT = './runs/'
#%% Load results

LOAD_NAME = 'CIFAR10_LinBregSparse_ne10_updtf1_updtd1_s_2025-07-31_12-37-01' # replace with actual name

conf, reader, model = sl.load_results(LOAD_NAME, ROOT, include_model=True)

#%% Display figures and tables
df = reader.scalars 
# Could alternatively load the CSV file but the 
#   CSV only contains scalars and we have potentially saved tensors

pf.display_sparsity_table(model)
pf.plot_df(df, include_layer_sparsity=False)