from langchain.prompts import PromptTemplate

# Basic planner agent prompt for direct planning
planner_agent_prompt = PromptTemplate.from_template(
"""You are a travel planning expert. Given the query and available information, create a detailed travel plan.

Available Information:
{given_information}

Query: {query}

Please provide a comprehensive travel plan that addresses all aspects of the query including transportation, accommodation, attractions, and dining. Format your response as a detailed itinerary."""
)

# Chain-of-Thought planner agent prompt
cot_planner_agent_prompt = PromptTemplate.from_template(
"""You are a travel planning expert. Given the query and available information, create a detailed travel plan using step-by-step reasoning.

Available Information:
{given_information}

Query: {query}

Let's think step by step:
1. First, analyze the requirements from the query
2. Then, consider transportation options
3. Next, plan accommodation needs
4. After that, select attractions and activities
5. Finally, arrange dining options

Please provide a comprehensive travel plan that addresses all aspects of the query."""
)

# ReAct planner agent prompt
react_planner_agent_prompt = PromptTemplate.from_template(
"""You are a travel planning expert using the ReAct (Reasoning and Acting) framework. You can take actions to gather information and reason about travel planning.

Available Information:
{text}

Query: {query}

{scratchpad}

Available Actions:
- CostEnquiry[plan_dict]: Check the cost of a travel plan (provide as JSON dictionary)
- Finish[answer]: Provide the final travel plan

You should think step by step, take actions to gather necessary information, and then provide a comprehensive travel plan.

Think about what information you need and what action to take next."""
)

# ReAct reflect planner agent prompt
react_reflect_planner_agent_prompt = PromptTemplate.from_template(
"""You are a travel planning expert using the ReAct (Reasoning and Acting) framework with reflection capabilities. You can take actions to gather information and reason about travel planning.

Available Information:
{text}

Query: {query}

{reflections}

{scratchpad}

Available Actions:
- CostEnquiry[plan_dict]: Check the cost of a travel plan (provide as JSON dictionary)
- Finish[answer]: Provide the final travel plan

You should think step by step, take actions to gather necessary information, learn from previous reflections, and then provide a comprehensive travel plan.

Think about what information you need and what action to take next."""
)

# Reflection prompt
reflect_prompt = PromptTemplate.from_template(
"""You are a travel planning expert reflecting on a previous planning attempt. Analyze what went wrong and provide insights for improvement.

Available Information:
{text}

Query: {query}

Previous Attempt:
{scratchpad}

Reflect on the previous attempt:
1. What were the main issues or mistakes?
2. What information was missing or incorrect?
3. How could the planning process be improved?
4. What should be done differently next time?

Provide a concise reflection that will help improve future planning attempts."""
)

# Slow thinking prompt
slow_thinking_prompt = PromptTemplate.from_template(
"""You are a travel planning expert who takes time to think carefully about each aspect of the planning process.

Available Information:
{given_information}

Query: {query}

Take your time to think through this travel planning request carefully. Consider:

1. **Understanding the Request**: What exactly is being asked for?
2. **Constraints Analysis**: What are the limitations and requirements?
3. **Resource Planning**: What transportation, accommodation, and activity options are available?
4. **Budget Considerations**: How to optimize within any budget constraints?
5. **Feasibility Check**: Is the plan realistic and executable?
6. **Quality Assessment**: How to ensure a high-quality travel experience?

Think through each step methodically and provide a detailed, well-reasoned travel plan."""
)

# Slow reflect prompt
slow_reflect_prompt = PromptTemplate.from_template(
"""You are a travel planning expert reflecting deeply on a previous planning attempt.

Available Information:
{given_information}

Query: {query}

Previous Planning Attempt:
{previous_attempt}

Take time to carefully reflect on the previous attempt:

1. **Requirement Analysis**: Were all requirements from the query properly addressed?
2. **Information Usage**: Was the available information used effectively?
3. **Planning Logic**: Was the reasoning sound and logical?
4. **Constraint Compliance**: Were all constraints properly considered?
5. **Quality Assessment**: What aspects could be improved?
6. **Alternative Approaches**: What other strategies might work better?

Provide a thoughtful reflection that identifies specific areas for improvement."""
)

# Extract value prompt
extract_value_prompt = PromptTemplate.from_template(
"""Extract the key values and information from the following travel planning context:

Context: {context}

Please extract:
1. Destination(s)
2. Travel dates
3. Number of travelers
4. Budget constraints
5. Specific preferences or requirements
6. Transportation preferences
7. Accommodation needs
8. Activity interests

Format the extracted information clearly and concisely."""
)

# Constants for formatting
REFLECTION_HEADER = "Previous Reflections and Learnings:\n"

PLAN_CONVERT = """Please convert the following travel plan text into a structured JSON format. The JSON should have the following structure:

{
  "days": [
    {
      "day": 1,
      "current_city": "city name or travel route",
      "transportation": "transportation details",
      "breakfast": "restaurant name and location",
      "attraction": "attraction name and location", 
      "lunch": "restaurant name and location",
      "dinner": "restaurant name and location",
      "accommodation": "hotel/accommodation name and location"
    }
  ]
}

Make sure to:
1. Include all days mentioned in the plan
2. Format location names as "Name, City"
3. Use "-" for any missing information
4. Ensure all JSON syntax is correct
"""

TRIP_PLAN_CONVERT = """Please convert the following travel plan text into a structured JSON format. 
Output the JSON only, no other text.
"""

THOUGHT_CONVERT = """Please convert the following reasoning and thoughts into a structured format that clearly shows:

1. Problem Understanding
2. Key Considerations
3. Planning Steps
4. Decision Rationale
5. Final Recommendations

Format the thoughts in a clear, logical sequence that can be easily followed."""
