from pydantic import BaseModel, Field
from enum import Enum
from typing import List, Optional, Union


class PeriodType(str, Enum):
    """Period type enumeration"""
    morning = "上午"
    afternoon = "下午"  
    evening = "晚上"
    night = "夜晚"
    all_day = "全天"

class TypeEnum(str, Enum):
    transportation = "transportation"
    poi = "poi"
    hotel = "hotel"
    lodgingArea = "lodgingArea"

class DetailItem(BaseModel):
    type: TypeEnum = Field(description="详情类型")
    id: str = Field(description="详情ID")
    name: str = Field(description="详情名称")

class ScheduleDetail(BaseModel):
    """Period arrangement details"""
    period: str = Field(description="时间段：上午、下午、晚上等")
    description: str = Field(description="该时间段的详细安排描述")
    detailList: List[DetailItem] = Field(
        description="该时间段涉及的具体项目列表"
    )

class DayInfo(BaseModel):
    """Single day itinerary information"""
    day: int = Field(description="行程第几天", ge=1)
    scheduleTitle: str = Field(description="当日行程标题")
    scheduleDetail: List[ScheduleDetail] = Field(
        description="当日各时间段的详细安排"
    )

class Tips(BaseModel):
    """Itinerary tips information"""
    title: str = Field(description="提示标题")
    info: List[str] = Field(description="提示信息列表")


class TravelItinerary(BaseModel):
    """Complete travel itinerary"""
    itineraryName: str = Field(description="行程名称")
    recommendReason: str = Field(description="推荐理由")
    dayInfos: List[DayInfo] = Field(description="各日行程安排列表")
    tips: Tips = Field(description="行程相关提示")

