def init_agent(kwargs):
    from .nesy_agent.rule_driven_rec import RuleDrivenAgent
    from .nesy_agent.llm_driven_rec import LLMDrivenAgent
    from .llm_modulo import LLMModuloAgent
    from .direct.direct_agent import DirectAgent
    from .cot.cot_agent import CoTAgent
    from .hypertree.hypertree_agent import HyperTreeAgent
    from .ttg_agent.ttg_agent import TTGAgent

    if kwargs["method"] == "RuleNeSy":
        agent = RuleDrivenAgent(
            env=kwargs["env"],
            backbone_llm=kwargs["backbone_llm"],
            cache_dir=kwargs["cache_dir"],
            debug=kwargs["debug"],
        )
    elif kwargs["method"] == "LLMNeSy":
        agent = LLMDrivenAgent(   
            **kwargs
        )
    elif kwargs["method"] == "LLM-modulo":
        kwargs["model"] = kwargs["backbone_llm"]
        kwargs["max_steps"] = kwargs["refine_steps"]
        agent = LLMModuloAgent(
            **kwargs
        )
    elif kwargs["method"] == "Direct":
        agent = DirectAgent(
            **kwargs
        )
    elif kwargs["method"] == "CoT":
        agent = CoTAgent(
            **kwargs
        )
    elif kwargs["method"] == "HyperTree":
        agent = HyperTreeAgent(
            **kwargs
        )
    elif kwargs["method"] == "TTG":
        agent = TTGAgent(
            **kwargs
        )
    else:
        raise Exception("Not Implemented")
    return agent


def init_llm(llm_name, max_model_len=None):
    from utils.llms import Deepseek, GPT4o, EmptyLLM, Gemini, Qwen3, CustomizedLLM

    if llm_name == "deepseek":
        llm = Deepseek()
    elif llm_name == "gpt-4o":
        llm = GPT4o(max_model_len=max_model_len)
    elif llm_name == "gemini":
        llm = Gemini(max_model_len=max_model_len)
    elif llm_name.startswith("Qwen3"):
        llm = Qwen3(model_name=llm_name, max_model_len=max_model_len)
    elif llm_name == "rule":
        return EmptyLLM()
    elif llm_name.startswith("customized"):
        llm = CustomizedLLM(max_model_len=max_model_len, model_name=llm_name)
    else:
        raise Exception("Not Implemented")

    return llm