import sys
import os
from typing import List, Dict

from agent.nesy_agent.nesy_utils.base_func import func_dict
import pandas as pd
from evaluators.commonsense_evaluator import CommonsenseEvaluator
from copy import deepcopy
from utils.poi_analyzer import POIAnalyzer

restaurants = {}
accommodation = {}
attractions = {}


def evaluate_constraints_py(query:Dict, plan:Dict, verbose:bool=False)->List[bool]:
    results = []
    for constraint in query["hard_logic_py"]:
        vars_dict = deepcopy(func_dict)
        vars_dict["plan"] = plan
        vars_dict["query_i"] = query
        try:
            # Evaluate the constraint in a safe manner
            exec(   
                constraint,
                {
                    "__builtins__": {
                        "set": set,
                    }
                },
                vars_dict,
            )
            res_i = vars_dict.get("result", False)
            results.append(bool(res_i))
        except Exception as e:
            if verbose:
                print(f"Error evaluating constraint '{constraint}': {e}")
            results.append(False)
    return results


def func_commonsense_constraints(query:Dict, plan:Dict, verbose:bool=False,poi_analyzer:POIAnalyzer=None)->List[bool]:
    commonsense_evaluator = CommonsenseEvaluator(poi_analyzer)
    data = {
                "itinerary": plan,
                "poi_dict": query
            }
    detailed_scores, details = commonsense_evaluator.evaluate(data)
    print("="*100)
    print("Commonsense Constraints Details:")    
    print(details['violations'])

    return True if details['total_violations']==0 else False



