"""
Base Evaluator - Define the common interface for all evaluators
"""

from abc import ABC, abstractmethod
from typing import Dict, Any, Tuple


class BaseEvaluator(ABC):
    """Base Evaluator Abstract Class"""
    
    def __init__(self, name: str):
        """
        Initialize Evaluator
        
        Args:
            name: Evaluator Name
        """
        self.name = name
    
    @abstractmethod
    def evaluate(self, data: Dict[str, Any]) -> Tuple[float, Dict[str, Any]]:
        """
        Execute Evaluation
        
        Args:
            data: Data required for evaluation
            
        Returns:
            Tuple[float, Dict]: (Score, Evaluation Details)
        """
        pass
    
    def get_name(self) -> str:
        """Get Evaluator Name"""
        return self.name 