

evaluation_system_prompt_en = """You are a professional travel itinerary evaluation expert, responsible for evaluating whether the generated itinerary meets the user's specific request and expectations."""

evaluation_prompt_v2_en = """Please evaluate the following travel itinerary based on the assessment criteria to determine whether it meets the user's specific request and expectations.

**User Request: **
{user_request}

**Generated Itinerary Response: **
{answer_text}

You need to carefully analyze the user's requirements and evaluate the itinerary's alignment based on the following aspects: Departure/Destination, Schedule/Timing, Mode of Transportation, Number of Travelers, Accommodation Requirements, Coverage of Attractions, Activity Types, Pace of the Trip, Budget, Other Requirements

**Scoring Criteria**
5 points: Excellent. The itinerary fully meets all the user's requirements and considers potential personalized needs, providing a travel plan that exceeds expectations.
4 points: Good. The itinerary fully meets all the user's core requirements; however, there are details that could be further optimized.
3 points: Average. The itinerary satisfies most user requirements, such as mandatory budget, schedule, and number of travelers, but some aspects are not adequately addressed.
2 points: Poor. The itinerary fails to meet the user's main requirements, with most elements misaligned with their preferences.
1 point: Very Poor. The itinerary completely fails to meet the user's expectations and is irrelevant to their request.
0 points: The user did not provide any specific information (e.g., "Plan a trip for me"), in which case any itinerary offered can be considered as meeting the user's needs.

**Instructions for Scoring**
1. Your evaluation should focus on determining whether the provided itinerary meets the user's expectations.
2. If IDs are provided for transportation, POIs, or hotels, you may assume these details are authentic and reliable.
3. Before assigning a score, analyze the itinerary and the user’s request, explaining why you assigned that score.
4. If the user's request changes midway, base your evaluation on the latest requirements.
5. You only need to evaluate the current itinerary. If the user requests multiple or alternative options, this should not result in a deduction.
6. Strictly follow the JSON format below when providing the evaluation result

Output format:
{{
    "detailed_feedback": "Detailed evaluation feedback",
    "final_score": Final score (0-5)
}}
"""


evaluation_system_prompt_zh = """你是一个专业的旅行行程评估专家，负责评估生成的行程是否符合用户的具体请求和期望。"""

evaluation_prompt_v1 = """
请评估以下旅行行程是否符合用户的具体请求和期望。

**用户请求：**
{user_request}

**生成的行程回答：**
{answer_text}

**评估要求：**
请从以下几个方面评估行程的符合程度（每个方面0-1分）：

1. **出发地/目的地** - 是否覆盖了用户要求的出发地和目的地
2. **时间安排** - 时间是否符合用户指定的日期和天数
3. **交通方式** - 行程是否与用户提出的交通方式一致
4. **出行人数** - 是否考虑了用户的出行人数
5. **住宿要求** - 是否考虑了用户的住宿要求
6. **景点覆盖** - 是否覆盖了用户要求的景点
7. **活动类型** - 推荐的景点和活动是否符合用户的兴趣和偏好，是否覆盖了经典景点
8. **行程节奏** - 行程节奏是否符合用户的要求，是否行程过紧或过松
9. **预算** - 是否考虑了用户的预算限制
10. **其他要求** - 是否满足用户提出的其他需求


**评分时注意如下要求：**
1. 用户的请求可能是多次的，如果用户的需求中途有变更，请以最新需求为准
2. 如果某一项要求，在用户的请求中没有提及，那么该项不计分，默认给-1
3. 0分表示完全不符合，1分表示完全符合，给分的分辨率是0.1
4. 你的评估目标为行程是否符合用户期望，是否满足了用户明确提出的要求

请以JSON格式返回评估结果,不要包含任何其他内容：
{{
    "detailed_feedback": "详细的评估反馈",
    "compliance_aspects": {{
        "departure_destination_compliance": 出发地/目的地符合度分数(0-1),
        "time_compliance": 时间安排符合度分数(0-1),
        "traffic_compliance": 交通方式符合度分数(0-1),
        "travel_group_compliance": 出行人数符合度分数(0-1),
        "accommodation_compliance": 住宿要求符合度分数(0-1),
        "attraction_compliance": 景点覆盖符合度分数(0-1),
        "activity_type_compliance": 活动类型符合度分数(0-1),
        "trip_pace_compliance": 行程节奏符合度分数(0-1),
        "budget_compliance": 预算符合度分数(0-1),
        "other_requirements_compliance": 其他要求符合度分数(0-1)


    }}
}}
"""




evaluation_prompt_v2_zh = """请根据评估标注，评估以下旅行行程是否符合用户的具体请求和期望。

**用户请求：**
{user_request}

**生成的行程回答：**
{answer_text}


你需要仔细分析用户提出的要求，然后从出发地/目的地、时间安排、交通方式、出行人数、住宿要求、景点覆盖、活动类型、行程节奏、预算、其他要求等几个方面评估行程的符合程度。


**评分标准**
5分：优秀，行程安排完全满足了用户的所有硬性要求，并考虑了潜在的个性化需求，给出了超出预期的旅行规划。
4分：良好，行程安排完全满足了用户的所有硬性要求，然而还有细节需要优化。
3分：平均，满足了用户的大部分的要求，如硬性的预算要求、时间要求、人数要求等，但仍有部分要求没能满足。
2分：差，行程安排未能满足用户的主要要求，大多数元素与用户偏好设定不符 。​​​​
1分：非常差，行程安排完全不符合用户的要求，给出的行程与用户要求无关。
0分：用户没有提供任何信息，如"帮我规划一次旅行"，这样给出的行程都能满足用户的需求


**评分时注意如下要求：**
1. 你的评估目标为确认我们提供的行程是否符合用户期望。
2. 出行方式、poi、hotel只要提供了id，可以假定这些信息都是真实可靠的。
3. 给出分数前，请先对行程和用户需求进行分析，说明为什么给出这个分数。
4. 用户的请求可能是多次的，如果用户的需求中途有变更，请以最新需求为准
5. 你只需要针对当前行程进行评估，如果用户在请求中希望提供多个方案/提供备选方案，不属于没有满足用户的要求，不进行扣分。
6. 严格的按照下面给出的JSON格式返回评估结果

输出格式：
{{
    "detailed_feedback": "详细的评估反馈",
    "final_score": 最终分数(0-5)
}}
"""

