#!/bin/bash

# try beta_point = 1287 (calculated with L = 2048)
# python perplexity_yarn.py --tokenized output/govreport-test-tokenized-awq \
# --dataset-min-tokens 20384 --samples 10 \
# --output-file ppl_results/new_embedding_only \
# --min-tokens 256 --max-tokens 19456 -m /home/yeq6/Research_project/llama/llama-2-7b-chat_hf \
# --awq_cache llm-awq/awq_cache/llama2-7b-w4-g128_mine.pt \
# --awq_rescale_temp 5 --beta_point 1287 --sliding-window 2048 --tokens-step 384 --aggressive-memory --yarn 8 \
# --original --custom-model --original-max-position-embeddings 2048 --awq

# Base command
base_command="python perplexity_yarn.py --tokenized output/govreport-test-tokenized-awq \
--dataset-min-tokens 20384 --samples 10 \
--output-file ppl_results/new_embedding_only \
--min-tokens 256 --max-tokens 19456 -m /home/yeq6/Research_project/llama/llama-2-7b-chat_hf \
--awq_cache llm-awq/awq_cache/llama2-7b-w4-g128_mine.pt \
--beta_point 1287 --sliding-window 2048 --tokens-step 384 --aggressive-memory --yarn 8 \
--original --custom-model --original-max-position-embeddings 2048 --awq"

# Ranges for --awq_rescale_temp
range1=$(seq 0.1 0.1 1.0)  # From 0.1 to 1 with step size of 0.1
range2=$(seq 1 1 10)       # From 1 to 10 with step size of 1

# Initialize a counter
counter=0

# Loop through both ranges
for temp in $range1 $range2; do
  # Increment the counter
  counter=$((counter + 1))
  
  # Construct the full command with the current --awq_rescale_temp value
  current_command="$base_command --awq_rescale_temp $temp"
  
  # Print and execute the command
  echo "Running command $counter/20: $current_command"
  eval $current_command
  
  # Exit the loop after 20 iterations
  if [ "$counter" -eq 20 ]; then
    break
  fi
done

echo "All 20 runs for temperature from 0.1 to 10 are completed."
