#!/bin/bash

# test dynamic yarn without awq
python perplexity_yarn.py --tokenized output/govreport-test-tokenized \
--dataset-min-tokens 20384 --samples 10 --output-file ppl_results/govreport_yarn.csv \
--min-tokens 256 --max-tokens 19456 -m /home/yeq6/Research_project/llama/llama-2-7b-chat_hf \
--sliding-window 2048 --tokens-step 384 --aggressive-memory --yarn 8 --original --custom-model \
--original-max-position-embeddings 2048


# test dynamic yarn with awq
python perplexity_yarn.py --tokenized output/govreport-test-tokenized-awq \
--dataset-min-tokens 20384 --samples 10 --output-file ppl_results/govreport_yarn.csv \
--min-tokens 256 --max-tokens 19456 -m /home/yeq6/Research_project/llama/llama-2-7b-chat_hf \
--quant_path /home/yeq6/Research_project/llama/llm-awq/quant_cache/llama-2-7b-chat-w4-g128-awq-v2.pt \
--sliding-window 2048 --tokens-step 384 --aggressive-memory --yarn 8 --original --custom-model \
--original-max-position-embeddings 2048 --awq