# benchmarking

`__main__.py` is the entrypoint script, `classifier.py` is a pytorch lightning module which
should be easily adjustable to other tasks beyond MNIST.

# pyrfd

Pytorch implementation of RFD

## Covariance model

Provides an implementation of the `SquaredExponential` and `RationalQuadratic` covariance model
with an `auto_fit` function, which requires only
1. A `model_factory` which returns the same but **randomly initialized** model every time it is called
2. A `loss` function e.g. `torch.nn.functional.nll_loss`
which accepts a prediction and a true value
3. data, which can be passed to `torch.utils.DataLoader` with different batch size parameters such
    that it returns `(x,y)` tuples when iterated on
4. a `csv` filename which acts as the cache for the covariance model ofthis
unique (model, data, loss) combination.

## Implementation of RFD

Such a covariance model can then be passed to `RFD` which implements the
pytorch optimizer interface. The end result can be used like `torch.optim.Adam`

# other folders

- `cache` is used as a sample cache for RFD, we left our runs inside for easier
reproducability. Delete this folder if you want to try sampling yourself.
- `data` is used as a cache for data such as MNIST
- `logs` is where the pytorch lightning logs are stored. This directory was
emptied for the supplemental due to size. Since training used seeds, this should
be easy to refill.