#!/bin/bash

# Check if input directory is provided
if [ $# -eq 0 ]; then
    echo "Usage: $0 <input_dir> [output_dir]"
    echo "Example: $0 results/advbench/self_Qwen2.5-7B-Instruct_q_10_cot"
    exit 1
fi

INPUT_DIR=$1
OUTPUT_DIR=${2:-"results/advbench"}

# Run the evaluation
python -m src.evaluation_self --dataset advbench --input_dir "$INPUT_DIR" --output_dir "$OUTPUT_DIR"

echo "Evaluation completed. Results saved in $OUTPUT_DIR" 
