#!/bin/bash

DATASETS=("gsm8k" "collegemath" "math500" "aime2024" "aime2025")

for dataset in "${DATASETS[@]}"; do
    echo "=================================================================="
    echo "Evaluating self-agent models for $dataset..."
    echo "=================================================================="
    bash scripts/eval/eval_math_self.sh "$dataset"
    
    echo "=================================================================="
    echo "Evaluating multi-agent models for $dataset..."
    echo "=================================================================="
    bash scripts/eval/eval_math_multi.sh "$dataset"
    
    echo "=================================================================="
    echo "✅ Completed evaluation for $dataset"
    echo "=================================================================="
done

echo "✅ All evaluations complete!" 