import torch


class Scaler:
    def __init__(self, mins, maxs):
        self.x0 = 0.5 * (maxs + mins)
        self.scale0 = 0.5 * (maxs - mins)

    def _cast(self, data):
        if isinstance(data, torch.Tensor):
            tmp = data.detach().clone()
        else:
            tmp = data
        return tmp

    def scale(self, data, bare=False):
        if bare:
            return self._cast(data) / self.scale0
        else:
            return (self._cast(data) - self.x0) / self.scale0

    def unscale(self, data, bare=False):
        if bare:
            return self._cast(data) * self.scale0
        else:
            return self._cast(data) * self.scale0 + self.x0
