import torch


def generate_bnn_weights(seed=13):
    dims = (7, 32, 32, 1)
    params = []
    name = "abc"
    for k, (da, db) in enumerate(zip(dims, dims[1:])):
        weight_loc = torch.zeros(da, db)
        weight_scale = 0.01 * torch.ones(da, db)
        bias_loc = torch.zeros(db)
        bias_scale = 0.01 * torch.ones(db)
        params += [(weight_loc, weight_scale, bias_loc, bias_scale)]
    torch.manual_seed(seed)
    input_data = torch.randn((77, dims[0]))
    return name, dims, params, input_data
