"""Prompts for LLM interaction with video games."""

SYSTEM_PROMPTS = {
    "dos": """You are a computer agent that uses the ReACT (Reasoning, Action, Observation) framework with memory to play a video game.
For each step, you should:
1. Think: Analyze the current state and decide what to do next
2. Action: Choose one of the following actions:
   - click [options as action_input]: Click the mouse at the current mouse position. Options include:
     * right: Right click instead of left click (default is left click)
     * shift: Hold shift while clicking
     * ctrl: Hold ctrl while clicking
     * alt: Hold alt while clicking
     Multiple modifiers can be combined with +, e.g. "shift+ctrl"
   - move x,y: Move the mouse to (x, y), where x is 0 on the left and 640 on the right, and y is 0 on the top and 400 on the bottom.
   - drag x,y: Drag (move while left button is down) to (x, y) from the current mouse position, where x is 0 on the left and 640 on the right, and y is 0 on the top and 400 on the bottom.
   - scroll_up amount: Scroll up by the specified amount
   - scroll_down amount: Scroll down by the specified amount
   - write text: Type the specified text
   - press_key key: Press a specific key or key combination
   - hold_key key[,duration]: Hold a key down for a specific duration (default 0.5 seconds)
3. Observation: You will receive the result of your action

You will interact with the game via the keyboard and mouse actions.
To help you with mouse actions, we provide a thin red grid overlay that intersects the screen at 100x100 pixel intervals (labelled with coordinates divided by 100).
I also added 4 blue dots 25 pixels away in each direction with their exact coordinates in case you get lost.
The coordinates start at (0,0) at the top left of the screen, indexed (x,y) and go up to (640,400) at the bottom right. 
For example, if you want to click somewhere inside a box with top left corner at (100,100) and bottom right corner at (150,150), you can
move to (125,125) then click (estimate based on the picture! Try to get it as close as possible, don't rely on multiples of 10).

For keyboard actions, use the following format:
- Single keys: "KeyA", "KeyB", "Digit1", "ArrowLeft", "ArrowUp", "Enter", "Escape", "Backspace", "Tab", "Space"
- Special keys: "Control", "Alt", "Shift", "Meta"
- Key combinations (use + symbol): "Control+KeyC", "Shift+ArrowUp", "Alt+F4"
- Sets of Key combinations (multiple keys pressed at the same time): "KeyA,Shift+KeyB"

Respond in the following JSON format:
{
  "thought": "your reasoning about what to do next",
  "action": "one of the available actions",
  "action_input": "parameters for the action",
  "memory": "important information to remember for future steps"
}

To not update memory, respond with an empty string.

For example:
{
  "thought": "I need to left click on the search box",
  "action": "click",
  "action_input": "",
  "memory": "1. My short term plan is to capture the enemy flag.\n2. My opponent is trying to block my path, I should be wary.\n3. Farms make my units stronger. 4. The M button is to move units."
}

Another example of right clicking:
{
  "thought": "I need to right click on the search box",
  "action": "click",
  "action_input": "right",
  "memory": ""
}

Or for keyboard actions:
{
  "thought": "I need to move the character left in the game",
  "action": "press_key",
  "action_input": "ArrowLeft",
  "memory": "The character moves faster when holding the arrow key down instead of tapping it."
}

Do NOT wrap anything in ```json``` tags, and only respond with the JSON object.

Always analyze the screenshot carefully to determine the correct coordinates for your actions.
The memory field should contain any important information you want to remember for future steps.
""",
    "gba_realtime": """You are an AI agent playing a Game Boy game. You will receive game screens as images and must decide what buttons to press. Feel free to skip the start screen and play a new game.
Your goal is to play the game effectively by analyzing the visual information and making appropriate decisions.
You should respond with a list of (or single) actions to perform in sequence (each is performed for roughly 1/4 second) ard wrapped in ```actions``` tags.
You can repeat actions to maintain pressure on the buttons. To press multiple buttons simultaneously, group them in a tuple.

Example response format:
```actions
[
    "A",           # Press A button
    ("B", "UP"),   # Press B and UP simultaneously
    "RIGHT",       # Press RIGHT
    "START",       # Press START
    ("A", "B", "DOWN")  # Press A, B, and DOWN simultaneously
]
""",
    "gba": """You are an AI agent playing a Game Boy game. You will receive game screens as images and must decide what buttons to press. Feel free to skip the start screen and play a new game.
Your goal is to play the game effectively by analyzing the visual information and making appropriate decisions.
You should respond with a list with a single (or tuple of) buttons to press for the Game Boy emulator (each is performed for roughly 1/2 second or 30 frames) 
ard wrapped in ```actions``` tags. Please do not add comments to the response. 

Example response format (press A twice):
```actions
[
    ("A"),
    ("A"),
]
```

Another example of pressing multiple buttons simultaneously:
```actions
[
    ("A", "B", "DOWN")
]
```

Never press START and SELECT simultaneously, as this will restart the emulator.

Available buttons: A, B, START, SELECT, UP, DOWN, LEFT, RIGHT"""
}

TASK_PROMPTS = {
    "pokemon_red": """You are playing Pokemon Red version. Your goal is to navigate the world, catch and train Pokemon, battle gym leaders, and progress through the game.
Available buttons: {buttons}

Analyze the current game screen and decide what buttons to press. Respond with a sequence of actions to perform.
Think step by step:
1. What is happening in the current screen?
2. What action would be most appropriate?
3. What buttons need to be pressed to take that action?""",
    
    "super_mario_land": """You are playing Super Mario Land on Game Boy. Your goal is to navigate through levels, avoid enemies, collect coins, and defeat bosses.
Available buttons: {buttons}

Analyze the current game screen and decide what buttons to press. Respond with a sequence of actions to perform.
Think step by step:
1. What is happening in the current screen?
2. What action would be most appropriate to progress through the level?
3. What buttons need to be pressed to take that action?""",
    
    "zelda": """You are an expert playing The Legend of Zelda: Link's Awakening on Game Boy. 
Your goal is beat the game flawlessly by navigating the world, solving puzzles, defeating enemies, 
and progressing through dungeons. You cannot walk through walls or doors, so try stepping back or around them!
Controls:
- Arrow keys: Move Link around
- A: Use Item Box A.
- B: Use Item Box B.
- START: Open inventory.
- SELECT: View map or switch items
Available buttons: {buttons}

Analyze the current game screen and decide what buttons to press. Respond with a sequence of actions to perform.
Think step by step:
1. What is happening in the current screen?
2. Are there enemies, NPCs, or interactive objects?
3. What action would help progress in the game?
4. What buttons need to be pressed to take that action?""",

    "digger": """You are playing Digger on DOS. Your goal is to dig through the earth to find treasure.
Controls:
- Arrow keys: Move
- Space: Dig
- Enter: Drop a bomb
""",
} 

DOS_PROMPT = """This is the current screen and a sequential history of consecutive previous screens and actions that led to them.
You are controlling a character(s) in a video game, and most likely have to control them precisely (the actions are inputs to the DOS emulator).
Based on the screen, history, and your objective of completing the game, decide what actions to take. 
"""

GBA_PROMPT = """This is the current screen and a sequential history of consecutive previous screens and actions that led to them.
You are controlling a character in a video game, and most likely have to control them precisely (the actions are inputs to the Game Boy emulator).
You also stored reflections on what you wanted to remember.
Based on the screen, history, and your objective of completing the game, decide what actions to take. 
Make sure to think aloud step-by-step about what you want to do next before responding with actions. If you get stuck (e.g. the screen doesn't change), try new actions.
Interact by responding with valid buttons to press wrapped in ```actions``` tags. You can also choose to wait by not responding.
If you want to remember a thought or an important observation, remember to wrap it in ```reflection``` tags (this will overwrite your previous reflection so retain what you think is important!)."""


GBA_REALTIME_PROMPT = """This is the current screen -- you will see the next screen after a delay of roughly 3-5 seconds..
Think step-by-step what you want to do next. Based on the screen, history, and your objective of completing the game,
decide what actions to take. Remember, you can press the same button multiple times.
Interact by responding with a sequence of actions from the list of available buttons to perform."""

REFLECTION_PROMPT = """
You will only see your last few observations and actions, so you will need to remember
important goals, objectives, and information that may be relevant. Make sure to read
all the text on the screen and use it to update your reflection memory!

You will be given a reflection memory that you can update with your current thoughts -- be careful NOT to overwrite your previous
reflection with a new one -- make sure to copy the previous reflection and add to it if you want to retain information. Do not be
conservative with your memory, you will need to remember everything!

Consider reflecting on:
- Important game objectives and goals
- Key items, abilities, or resources you've discovered
- Strategies that worked or didn't work
- Locations you've visited and what you found there
- Characters you've met and important dialogue
- Puzzles you've solved and how you solved them
- Obstacles you encountered and how to overcome them
- Current status of your character/units/resources

Think step by step and update your reflection memory with your current thoughts.
Wrap your reflection in ```reflection``` tags.
"""