# GCondNet: A Novel Method for Improving Neural Networks on Small High-Dimensional Tabular Data

## Installation
You must have **conda** and **cuda 11.7** installed locally.
```
conda create python=3.10 --name gcondnet
conda activate gcondnet
pip install -r requirements.txt
```
Change `BASE_DIR` from `/src/_config.py` to point to the project directory on your machine.


### (Optional) running lightgbm on CUDA requires special settings

```
pip install lightgbm --install-option=--gpu --install-option="--opencl-include-dir=/usr/local/cuda/include/" --install-option="--opencl-library=/usr/local/cuda/lib64/libOpenCL.so"
```


## Code structure
- `reproduce_figure_2.ipynb`: notebook to reproduce Figure 2 from the paper
- src
	- `main.py`: code for running experiments
	- `models.py`: GCondNet, WPFS, DietNetworks, FsNet and CAE
	- `graph.py`: the GNN as part of GCondNet, and code to compute the SRD/KNN/Random graphs
	- `dataset.py`:  loading the datasets
	- `gnn_classification`: GCN and GATv2 bechmark models
- data
	- cll, lung, prostate, smk, toxicity

# Running an experiment
1. Train GCondNet using `train_gcondnet.sh`
2. Run `analyze_experiments.ipynb`