import torch
import numpy as np

# --- Parity ---

GOLDEN_TEST_INPUT_PARITY = torch.tensor([0,1,0,1], dtype=torch.int32, device="cpu").unsqueeze(0)

GOLDEN_TEST_EXPECTED_PREDICTIONS_PARITY = torch.tensor([
  [[-0.15114553, -0.15012784, -0.1494543, -0.1489764, -0.14907491, -0.14927267, -0.14933608, -0.14955299, -0.14972058, -0.1498806 ],
   [ 0.2624941 ,  0.2634565 ,  0.26399443,  0.26413056, 0.26396865,  0.26372927,  0.26362813,  0.26334316, 0.26311958,  0.2628874 ],
   [-0.28391197, -0.28332087, -0.28294474, -0.28257406, -0.2826529 , -0.28262165, -0.28259748, -0.2825468 , -0.2825347 , -0.28248054],
   [-0.33456144, -0.33309337, -0.33224347, -0.33171314, -0.33218953, -0.3323768 , -0.3324911 , -0.33268487, -0.33287957, -0.33302853],
   [-0.32000315, -0.31972218, -0.31953937, -0.3192179 ,-0.31963587, -0.31950808, -0.3195026 , -0.31932688, -0.3192347 , -0.31908703],
   [-0.24259788, -0.24233091, -0.24214657, -0.2422754 , -0.24216418, -0.2422495, -0.24222665, -0.2423716, -0.2424487 , -0.24256945],
   [0.40723592, 0.40584758, 0.40501833, 0.40437087, 0.40481994, 0.4049197, 0.40497422, 0.4050744, 0.40519148, 0.4052573],
   [ 0.04918514,  0.04926468,  0.04920963,  0.04921019, 0.04843872,  0.04852331, 0.04838988, 0.04855606, 0.04859333, 0.04870945]]
], dtype=torch.float32, device="cpu")

GOLDEN_TEST_EXPECTED_CERTAINTIES_PARITY = torch.tensor([
  [[0.9863741, 0.9864259, 0.986457, 0.98649305, 0.9864521, 0.98645353, 0.9864482, 0.98645395, 0.98645365, 0.9864587],
   [0.01362592, 0.01357412, 0.01354301, 0.01350695, 0.0135479, 0.01354647, 0.01355177, 0.01354605, 0.01354635, 0.01354128]]
], dtype=torch.float32, device="cpu")

GOLDEN_TEST_EXPECTED_SYNCH_OUT_TRACKING_PARITY = np.array([
  [[ 0.00493190, -0.00876861, -0.00810784,  0.01620056,  0.01476090, 0.01352467]],
  [[ 0.00417055, -0.00762740, -0.00665991,  0.01475134,  0.01218212, 0.01105392]],
  [[ 0.00367095, -0.00688400, -0.00577276,  0.01408620,  0.01057410, 0.00957341]],
  [[ 0.00379351, -0.00719495, -0.00522702,  0.01471007,  0.00958735, 0.00857068]],
  [[ 0.00362379, -0.00720634, -0.00528148,  0.01596188,  0.01077586, 0.00944065]],
  [[ 0.00408370, -0.00790727, -0.00564644,  0.01687249,  0.01125949, 0.00952617]],
  [[ 0.00422591, -0.00826531, -0.00580602,  0.01764188,  0.01165420, 0.00958795]],
  [[ 0.00479519, -0.00903400, -0.00618728,  0.01853319,  0.01207959, 0.00966703]],
  [[ 0.00516949, -0.00961616, -0.00650192,  0.01934495,  0.01252532, 0.00981511]],
  [[ 0.00563606, -0.01026313, -0.00679497,  0.02013864,  0.01286431, 0.00986005]]
], dtype=np.float32)

GOLDEN_TEST_EXPECTED_SYNCH_ACTION_TRACKING_PARITY = np.array([
  [[6.9127731e-05, 1.0723926e-03, 4.5818978e-04, 1.6636243e-02, 7.1079913e-03, 3.0369561e-03]],
  [[7.2372837e-05, 7.5447041e-04, 2.9799779e-04, 1.1764224e-02, 5.0303414e-03, 2.1762087e-03]],
  [[7.3591633e-05, 6.3199661e-04, 3.1289359e-04, 9.6230470e-03, 4.1839126e-03, 2.1107616e-03]],
  [[8.7451842e-04, 3.0911725e-04, 6.1356218e-04, 8.4037883e-03, 3.5227225e-03, 1.9727300e-03]],
  [[1.3178950e-03, 3.4118973e-04, 9.7500376e-04, 7.5243926e-03, 3.2023010e-03, 2.1035718e-03]],
  [[2.6046557e-03, 2.9710043e-04, 1.9611258e-03, 6.8689468e-03, 2.9123125e-03, 2.7387883e-03]],
  [[3.8253744e-03, 2.2512165e-04, 3.0884920e-03, 6.3611730e-03, 2.6513210e-03, 3.6814574e-03]],
  [[4.7593736e-03, 2.1188198e-04, 3.8527022e-03, 5.9503336e-03, 2.4811444e-03, 4.2299996e-03]],
  [[5.7649608e-03, 1.3227727e-04, 4.7418200e-03, 5.6135929e-03, 2.2806483e-03, 4.9513904e-03]],
  [[6.6186152e-03, 1.5460076e-04, 5.4740994e-03, 5.3262589e-03, 2.1883210e-03, 5.5253385e-03]]
], dtype=np.float32)

GOLDEN_TEST_EXPECTED_PRE_ACTIVATIONS_TRACKING_PARITY = np.array([
    [[ 0.06150711, -0.72699386, -1.56490052,  1.68935311, -1.86509728, -1.52379560,  0.18236819,  0.09422535,  0.01004345, -0.26237217,  0.23528542, -0.20356508,  1.86362600,  0.97490674,  0.93740904, -0.68676311,  1.36023700, -1.47007239,  0.28592899, -0.62692535,  0.54907161, -0.42356881, -1.10483146, -0.47931203,  0.57466203,  0.95069546,  1.78335285, -0.46429592,  0.91231447, -1.45262170, -0.16320689,  0.55333507]],
    [[ 0.40242609, -1.25608170, -1.17458606,  2.34063673, -1.55169690, -1.69153023, -0.15924975, -0.07744192,  0.35690653, -0.42454216, -0.39263695, -0.54848593,  1.44541156,  1.24790835,  1.04919529, -0.55546719,  1.29617167, -1.43872964,  0.49377927, -0.90007627,  0.35406503, -0.53655815, -0.11270343, -0.66863436,  0.57249683,  0.68464565,  1.46730077, -0.58734804,  0.92569441, -1.36402965,  0.09062470,  0.71253490]],
    [[ 0.28492087, -1.26211202, -1.11561763,  2.24973226, -1.77080083, -1.69042456, -0.31452510,  0.20547554,  0.40897962, -0.44814718, -0.43359444, -0.62831175,  1.49666917,  1.22685397,  1.01995301, -0.54930609,  1.23225474, -1.41087365,  0.47305441, -0.74736178,  0.49463424, -0.60024643, -0.18957831, -0.58264750,  0.49291500,  0.75790811,  1.44818544, -0.57351053,  0.89701402, -1.34929729,  0.21288876,  0.76491421]],
    [[ 0.49497619, -1.20278561, -1.09975803,  2.27806449, -1.75627124, -1.70454204, -0.28705728,  0.18795460,  0.51110214, -0.39662105, -0.32655066, -0.65363854,  1.41716754,  1.34038091,  1.05080748, -0.59850252,  1.14449263, -1.39864194,  0.51516622, -0.66322756,  0.39529505, -0.54565734, -0.13753439, -0.67212278,  0.50756931,  0.69695020,  1.42806566, -0.67082071,  0.78664643, -1.49246633,  0.13731927,  0.71423936]],
    [[ 0.40436846, -1.29866207, -1.12483668,  2.14774346, -1.81288755, -1.61132753, -0.32845166,  0.48374757,  0.45603475, -0.30144054, -0.33106613, -0.67708087,  1.57461917,  1.26445472,  0.95887607, -0.62787455,  1.05634034, -1.54963291,  0.46107927, -0.63095075,  0.43131891, -0.50050884, -0.15604745, -0.56488484,  0.44325647,  0.72402531,  1.48713458, -0.70787108,  0.79360384, -1.41832590,  0.10957094,  0.84567523]],
    [[ 0.50984824, -1.29972041, -1.02062452,  2.33626866, -1.85169101, -1.53881967, -0.19770266,  0.18426917,  0.39905944, -0.27648085, -0.34496254, -0.67302299,  1.63759482,  1.21183848,  1.16254544, -0.62806380,  1.00981331, -1.40358770,  0.44916505, -0.70865571,  0.33515611, -0.57342756, -0.04108980, -0.49421832,  0.33095706,  0.78513849,  1.40141809, -0.71177024,  0.86523169, -1.46263850, -0.05074156,  0.65891421]],
    [[ 0.53081042, -1.28931272, -1.01259959,  2.33265781, -1.91281283, -1.51939821, -0.24213481,  0.19857667,  0.43884301, -0.23791833, -0.36490524, -0.72857261,  1.66428566,  1.23228884,  1.16550195, -0.63409120,  0.96603119, -1.39323390,  0.36738679, -0.62037802,  0.32761785, -0.56678259, -0.02044483, -0.51810014,  0.32791400,  0.79053128,  1.38151586, -0.68809557,  0.83703136, -1.46181202, -0.01562480,  0.66522563]],
    [[ 0.55238146, -1.29435539, -1.01444280,  2.33848619, -1.91447639, -1.52795780, -0.25460821,  0.19597431,  0.44474006, -0.22526333, -0.35448572, -0.71492916,  1.64960659,  1.21054220,  1.15785098, -0.61330491,  0.95968354, -1.38651836,  0.37719947, -0.64417225,  0.32399255, -0.56839812, -0.02869503, -0.52514917,  0.35403091,  0.78299457,  1.38281918, -0.69978845,  0.85363561, -1.46483147, -0.01177109,  0.65921074]],
    [[ 0.57497311, -1.29354680, -1.02482033,  2.33142686, -1.92916977, -1.51101530, -0.25199556,  0.20164521,  0.45205921, -0.20942001, -0.34977981, -0.73248214,  1.66943920,  1.21770024,  1.16757739, -0.62954998,  0.94365168, -1.38134861,  0.34668007, -0.61775929,  0.33036402, -0.54265636, -0.02963453, -0.53820479,  0.32623848,  0.79347003,  1.37951005, -0.69870555,  0.82111311, -1.47192979,  0.00300579,  0.65316427]],
    [[ 0.54927129, -1.31168723, -1.02038860,  2.33867574, -1.89717019, -1.53069592, -0.24128951,  0.21155187,  0.43477154, -0.22639556, -0.35501844, -0.73532718,  1.67045462,  1.21050704,  1.15592599, -0.61056936,  0.96232712, -1.38014948,  0.36231738, -0.63957793,  0.32370931, -0.56778890, -0.04194793, -0.53548175,  0.31153581,  0.81549567,  1.37881386, -0.68509907,  0.81965828, -1.45739818,  0.01348861,  0.67748100]]
  ], dtype=np.float32)

GOLDEN_TEST_EXPECTED_POST_ACTIVATIONS_TRACKING_PARITY = np.array([
    [[-1.52536330e-03,  3.20913419e-02,  1.91421360e-02, -1.76658444e-02,  6.43317914e-03, -2.98370011e-02,  3.14304326e-03,  1.40899653e-03, -2.23760289e-04, -8.52769706e-03, -7.98468012e-03,  7.79849337e-03,  2.54789833e-02,  2.79296655e-03, -5.43739600e-03,  1.04068043e-02, -3.19894589e-03,  2.26499587e-02, -4.05337568e-03, -1.10810734e-02, -7.12470431e-03, -1.07554905e-03, -4.57510278e-02,  1.85010433e-02, -5.21941576e-03, -8.13911483e-03,  2.56551690e-02, -1.16514172e-02,  4.44343947e-02,  5.76393213e-03, -9.38640034e-04, -6.37711445e-03]],
    [[-1.57746300e-02,  5.13713695e-02,  4.37961519e-03, -5.73335811e-02,  4.28702459e-02, -8.11760947e-02, -7.00818709e-05, -2.56345753e-04, -8.61901045e-03,  1.54141325e-03,  2.13586688e-02,  1.99399628e-02,  3.49074788e-02, -8.00257828e-03,  2.96621793e-03,  7.82306585e-03, -6.08445890e-03,  1.38461404e-02, -7.34569225e-03, -1.21022128e-02, -4.93428577e-03, -1.73566360e-02,  1.79299358e-02,  6.15092833e-03, -9.92602669e-03, -9.51348431e-03, -5.78342333e-05, -2.96221743e-03,  4.30940539e-02,  5.01136761e-03,  5.52104320e-03,  2.40483433e-02]],
    [[-1.08761285e-02,  5.12085892e-02,  9.40021127e-04, -6.78556636e-02,  3.72469425e-02, -1.03350095e-01, -6.96143508e-03,  2.78073270e-03, -1.19348438e-02, -3.85945989e-03, -4.97719599e-03,  2.80494913e-02, -5.97313093e-03, -1.04928715e-02,  1.04870675e-02,  1.40909646e-02,  4.93875891e-03, -1.32020637e-02,  3.22207087e-03,  4.02186392e-03, -1.75169297e-02, -2.78742542e-03, -4.80228662e-02,  4.46730247e-03, -8.78794212e-03, -1.41807841e-02, -1.86698791e-02, -1.21778008e-02,  3.13082151e-02,  4.02687527e-02, -1.18309045e-02,  1.70150995e-02]],
    [[-3.37734893e-02,  6.87045604e-02,  4.21753759e-03, -1.73333287e-02,  1.09923303e-01, -1.42490432e-01, -6.26494084e-03,  3.40421568e-04,  6.03374676e-04,  1.74239408e-02,  2.53275093e-02,  2.92120446e-02, -9.67750885e-03, -4.57768664e-02,  1.81739014e-02,  1.50834145e-02,  1.33866966e-02, -3.74200493e-02,  4.37944056e-03, -2.59829802e-03, -1.79842915e-02,  1.73825747e-03, -8.80279019e-03, -9.69431363e-03, -2.15052860e-03, -1.98961068e-02, -1.39401369e-02, -2.80045159e-02,  2.33044941e-02,  3.46102007e-02,  4.18052915e-03,  2.75366902e-02]],
    [[-1.98469888e-02,  7.87766278e-02,  6.29297718e-02, -4.76429500e-02,  7.84923807e-02, -1.11096412e-01, -2.23392388e-03, -2.09827558e-03, -4.72996011e-03,  1.33914677e-02,  4.94648563e-03,  3.34998108e-02,  4.08599824e-02, -8.23334977e-02,  4.40398976e-02,  8.15974548e-03,  3.38790333e-03, -3.65324654e-02, -8.93191621e-03, -2.40980145e-02, -5.93084842e-03,  2.29976457e-02, -1.88856814e-02, -1.42503884e-02, -1.32472045e-03, -1.69482753e-02,  3.20943892e-02, -5.34413829e-02,  6.70717508e-02,  5.85932992e-02, -6.00392639e-04,  4.47761603e-02]],
    [[-4.39092629e-02,  7.44442642e-02,  4.55972590e-02, -6.00988008e-02,  9.19933021e-02, -1.01410598e-01,  3.15332727e-04,  8.39407742e-03, -1.00196972e-02,  5.41754486e-03,  2.09150203e-02,  2.87449658e-02,  3.24463733e-02, -8.76663849e-02,  4.47240211e-02,  9.83812660e-03,  3.08353244e-03, -3.88560742e-02, -1.29286740e-02, -3.39327827e-02, -1.01778982e-02,  2.64202431e-02, -6.23800326e-03, -5.21383574e-03, -9.35503631e-05, -1.82694644e-02,  2.07018014e-02, -5.99396117e-02,  7.32543468e-02,  6.11629896e-02, -2.16027070e-03,  5.50598390e-02]],
    [[-3.38852704e-02,  7.25145712e-02,  4.37600464e-02, -6.23523220e-02,  8.94960612e-02, -9.79542062e-02,  2.45787855e-03,  9.37764347e-03, -1.19509697e-02,  2.40541412e-03,  2.49668192e-02,  2.96786241e-02,  3.15661058e-02, -9.05008465e-02,  4.53640223e-02,  1.02884537e-02,  2.53169145e-03, -4.10584696e-02, -1.44287422e-02, -2.77527925e-02, -5.55971684e-03,  2.57355813e-02, -8.60477705e-03, -8.75491928e-03,  2.79305474e-04, -1.80671159e-02,  1.98681299e-02, -6.30032942e-02,  6.94108754e-02,  5.77975102e-02,  6.36159893e-05,  4.71595749e-02]],
    [[-4.93244380e-02,  7.55036175e-02,  4.33849283e-02, -6.50863200e-02,  9.33675021e-02, -9.41886455e-02,  6.51015318e-04,  6.52258750e-03, -1.76842399e-02, -5.16754983e-04,  2.13508755e-02,  2.95291413e-02,  2.75329333e-02, -9.17686969e-02,  4.80427444e-02,  9.46405344e-03,  2.24814983e-03, -4.02613729e-02, -1.43697932e-02, -2.40827315e-02, -7.42546096e-03,  2.58454904e-02, -4.18188283e-03, -4.25320119e-03, -9.40437021e-04, -1.87266115e-02,  2.14372892e-02, -6.80221617e-02,  6.50662705e-02,  6.19139746e-02, -3.27003608e-03,  5.37580252e-02]],
    [[-4.42920923e-02,  7.46626779e-02,  4.51333039e-02, -5.89457490e-02,  9.44149420e-02, -9.42663476e-02,  1.88283535e-04, -1.08284196e-02, -1.52060259e-02,  2.09965697e-03,  2.19171196e-02,  3.00258175e-02,  3.10847349e-02, -8.76333117e-02,  4.69461568e-02,  9.45091993e-03,  2.29029171e-03, -3.86067517e-02, -1.53680192e-02, -2.43291762e-02, -5.16458601e-03,  2.42164433e-02, -2.75445520e-03, -3.17265280e-03, -1.70725200e-03, -1.92861389e-02,  2.30955984e-02, -6.89752698e-02,  6.43941313e-02,  6.02910966e-02,  1.52690301e-03,  5.11711203e-02]],
    [[-4.84286956e-02,  7.49548674e-02,  4.07919176e-02, -6.15066290e-02,  9.69815999e-02, -9.53533724e-02,  2.45919509e-04,  9.48794885e-04, -1.34753818e-02,  4.80859570e-04,  2.17879750e-02,  3.07949055e-02,  3.29777375e-02, -8.70253518e-02,  5.22310399e-02,  9.02995747e-03,  2.20961915e-03, -3.81485336e-02, -1.29481405e-02, -2.62128636e-02, -6.80494076e-03,  2.79318020e-02, -2.77501997e-03, -5.73279941e-03, -1.40039669e-03, -1.94234904e-02,  2.05609556e-02, -6.86758086e-02,  6.67321235e-02,  6.10304996e-02, -2.51930003e-04,  4.65794280e-02]]
  ], dtype=np.float32)

GOLDEN_TEST_EXPECTED_ATTENTIONS_TRACKING_PARITY = np.array([
  [
    [[[0.29265743, 0.24541821, 0.24280649, 0.21911786]],
     [[0.27554724, 0.25661728, 0.25488999, 0.21294554]]]
  ],
  [
    [[[0.29224804, 0.24547587, 0.24289204, 0.21938409]],
     [[0.27557027, 0.25659925, 0.25486910, 0.21296136]]]
  ],
  [
    [[[0.29208893, 0.24549824, 0.24292524, 0.21948767]],
     [[0.27557892, 0.25659201, 0.25486079, 0.21296827]]]
  ],
  [
    [[[0.29200158, 0.24551046, 0.24294341, 0.21954462]],
     [[0.27560416, 0.25658858, 0.25485516, 0.21295211]]]
  ],
  [
    [[[0.29194677, 0.24551822, 0.24295501, 0.21957998]],
     [[0.27562663, 0.25658709, 0.25485176, 0.21293452]]]
  ],
  [
    [[[0.29194823, 0.24551812, 0.24295494, 0.21957870]],
     [[0.27567148, 0.25658849, 0.25484961, 0.21289040]]]
  ],
  [
    [[[0.29198289, 0.24551329, 0.24294776, 0.21955609]],
     [[0.27570745, 0.25659016, 0.25484848, 0.21285391]]]
  ],
  [
    [[[0.29199445, 0.24551174, 0.24294552, 0.21954831]],
     [[0.27573952, 0.25659156, 0.25484738, 0.21282162]]]
  ],
  [
    [[[0.29202563, 0.24550734, 0.24293901, 0.21952797]],
     [[0.27576831, 0.25659305, 0.25484660, 0.21279207]]]
  ],
  [
    [[[0.29204682, 0.24550447, 0.24293479, 0.21951394]],
     [[0.27579799, 0.25659484, 0.25484613, 0.21276106]]]
  ]
], dtype=np.float32)

# --- QAMNIST ---

GOLDEN_TEST_EXPECTED_PREDICTIONS_QAMNIST = torch.tensor([
  [[-0.11054635, -0.10996059, -0.10958703, -0.10939968, -0.10932034, -0.10953235, -0.10939277, -0.1095684],
   [-0.095216, -0.09417876, -0.09354307, -0.09303258, -0.09269939, -0.09255031, -0.09233424, -0.09234115],
   [ 0.1240449, 0.12388709, 0.12382165, 0.12390161, 0.12390347,  0.12377567,  0.12377376,  0.12345331],
   [0.3951692, 0.39604402, 0.3965937, 0.3970002, 0.39727145,  0.39725277,  0.3974441, 0.39749283],
   [0.3020259, 0.30123204, 0.300718, 0.30040538, 0.30016407,  0.30032462,  0.30014738, 0.30010003],
   [-0.09802948, -0.09965418, -0.10062516, -0.10109514, -0.1013958 , -0.10108647, -0.10143414, -0.10158319],
   [ 0.17047977, 0.17087944, 0.17111899, 0.17129044, 0.17161483, 0.17145424, 0.17153656, 0.1714925 ],
   [ 0.3444301 , 0.34323055, 0.3425039 , 0.34207824, 0.34183362, 0.34199974, 0.3417371, 0.34174076],
   [-0.13890702, -0.13782687, -0.13718238, -0.13673624, -0.13635515, -0.13640471, -0.13617916, -0.13614221],
   [-0.3814568 , -0.38000864, -0.3791185 , -0.37850484, -0.37798077, -0.3780301 , -0.37772745, -0.37760583]]
], dtype=torch.float32, device="cpu")

GOLDEN_TEST_EXPECTED_CERTAINTIES_QAMNIST = torch.tensor([
  [[0.98781836, 0.98785514, 0.9878779, 0.9878928, 0.987904, 0.98790175, 0.9879095, 0.9879089 ],
   [0.01218164, 0.01214486, 0.01212209, 0.01210719, 0.01209599, 0.01209825, 0.0120905, 0.0120911 ]]
], dtype=torch.float32, device="cpu")

GOLDEN_TEST_EXPECTED_SYNCH_OUT_TRACKING_QAMNIST = torch.tensor([
  [[ 0.01937639, -0.00749642,  0.01025546,  0.00290193, -0.00397123, 0.00543547]],
  [[ 0.01592703, -0.00610805,  0.00839308,  0.00237095, -0.00324016, 0.00444163]],
  [[ 0.01379348, -0.00528652,  0.00726521,  0.00209279, -0.00284816, 0.00389145]],
  [[ 0.01244805, -0.00489620,  0.00643666,  0.00212597, -0.00245426, 0.00351480]],
  [[ 0.01153609, -0.00410415,  0.00585820,  0.00271436, -0.00227775, 0.00321036]],
  [[ 0.01214428, -0.00454289,  0.00554765,  0.00289029, -0.00217175, 0.00298272]],
  [[ 0.01137464, -0.00427495,  0.00517709,  0.00274775, -0.00201024, 0.00280031]],
  [[ 0.01110995, -0.00385626,  0.00456747,  0.00266925, -0.00203683, 0.00289494]]
], dtype=torch.float32, device="cpu")

GOLDEN_TEST_EXPECTED_SYNCH_ACTION_TRACKING_QAMNIST = np.array([
  [[0.00532434, 0.00205694, 0.00810542, 0.00079465, 0.00313134, 0.01233914]],
  [[0.00418766, 0.00156047, 0.00576105, 0.00058848, 0.00222163, 0.00872717]],
  [[0.00351884, 0.00117013, 0.00468646, 0.00058902, 0.00183213, 0.00712875]],
  [[0.00323656, 0.00121035, 0.00420456, 0.00071525, 0.00173869, 0.00628633]],
  [[0.00304458, 0.00113211, 0.00370722, 0.00065613, 0.00153744, 0.00564175]],
  [[0.00406662, 0.00158671, 0.00337482, 0.00083672, 0.00139945, 0.00515026]],
  [[0.01045823, 0.00298669, 0.00380612, 0.00111878, 0.00145020, 0.00483763]],
  [[0.01533980, 0.00236438, 0.00168609, 0.00107971, 0.00150136, 0.00515731]]
], dtype=np.float32)

GOLDEN_TEST_EXPECTED_PRE_ACTIVATIONS_TRACKING_QAMNIST = np.array([
  [[-1.10239863e-01,  5.15558600e-01, -1.48359388e-01,  1.74425319e-01,
    1.93116856e+00,  1.78442860e+00,  6.59696087e-02, -1.19394265e-01,
    1.12939835e+00, -2.04276490e+00, -4.18605238e-01,  1.33685732e+00,
    9.43623245e-01, -8.68898630e-01, -1.11860096e+00,  5.02186477e-01,
   -9.44085956e-01, -4.57132667e-01,  4.01662916e-01, -1.14714372e+00,
   -2.23103428e+00,  1.10001527e-01, -2.06494033e-01,  9.53701958e-02,
    2.23667815e-01,  9.90268826e-01,  3.09344660e-02,  8.64107370e-01,
   -1.56765199e+00,  1.13352478e+00, -9.80635583e-01,  1.27888367e-01]],

 [[-4.52981770e-01,  6.32077515e-01,  3.85402627e-02, -2.58348603e-02,
    2.48769546e+00,  1.32792020e+00, -4.68270361e-01,  3.45246762e-01,
    1.83276725e+00, -1.38327682e+00, -9.13786948e-01,  1.55682409e+00,
    1.10581481e+00, -6.14442766e-01, -1.60600698e+00,  2.99966633e-01,
    7.37593770e-02,  1.27465725e-02,  3.82697344e-01, -1.52852738e+00,
   -2.07893896e+00, -5.71185887e-01,  2.72807986e-01,  1.72059387e-02,
   -1.15560062e-01,  6.72998846e-01, -2.57013023e-01,  1.56698227e-01,
   -1.18528962e+00,  7.47847378e-01, -7.01769471e-01, -6.07297942e-02]],

 [[-7.28409961e-02,  6.70484781e-01,  5.27910829e-01,  1.95262730e-01,
    2.16163540e+00,  5.22522211e-01, -1.70064414e+00,  1.41201854e+00,
    1.57563782e+00, -1.54053032e+00, -3.27017367e-01,  1.10390508e+00,
   -5.30201912e-01, -6.72526240e-01, -1.72192797e-01,  5.77827580e-02,
   -3.44270319e-01, -4.62397158e-01, -1.08163559e+00,  1.42479435e-01,
   -8.77553940e-01,  9.21069860e-01, -1.46153674e-01, -8.98310363e-01,
    5.39113700e-01, -6.57568991e-01, -1.80240288e-01,  7.17753947e-01,
   -1.28439474e+00,  2.34900999e+00, -7.57092834e-01, -1.19101477e+00]],

 [[ 9.49405134e-01, -4.71318781e-01, -5.98576665e-01, -3.03835589e-02,
    1.74049485e+00,  8.68411064e-01,  8.19556177e-01,  4.68622059e-01,
    1.56338465e+00, -1.31375468e+00, -1.37466431e+00,  1.26715183e+00,
    7.80974105e-02, -9.42789078e-01, -1.30975813e-01,  1.39644301e+00,
    4.71525609e-01, -9.75015640e-01,  2.32380241e-01, -9.45483506e-01,
   -1.79443800e+00,  2.34525740e-01, -1.85149521e-01,  4.41924989e-01,
   -6.41037405e-01,  8.35259557e-01, -1.05998003e+00, -1.61294922e-01,
   -1.42364216e+00,  2.04387474e+00, -3.86112899e-01, -9.76441145e-01]],

 [[-1.22704208e-01,  6.38477802e-01,  1.70959517e-01,  2.38735870e-01,
    2.25300837e+00,  4.42267597e-01, -1.60111070e+00,  1.49321163e+00,
    1.47487664e+00, -1.64935064e+00, -5.41719437e-01,  1.19440019e+00,
   -6.51248634e-01, -6.31201506e-01, -1.06332779e-01,  1.98569760e-01,
   -3.40614378e-01, -3.28160465e-01, -9.51120913e-01,  6.25940040e-02,
   -8.27967465e-01,  1.00205588e+00, -1.69033911e-02, -7.27027118e-01,
    6.10986233e-01, -7.23374188e-01, -2.15887725e-01,  7.87200987e-01,
   -1.36306155e+00,  2.22626829e+00, -7.09241927e-01, -1.28658557e+00]],

 [[ 2.29575777e+00, -1.42140913e+00,  3.10963690e-02, -1.24277997e+00,
   -2.99814314e-01,  6.57263100e-01,  5.19852281e-01,  3.40675652e-01,
    1.54818147e-01, -7.26951122e-01, -1.63522661e-01, -1.48937690e+00,
   -1.69690347e+00, -6.25757039e-01,  7.40408301e-01,  2.02490956e-01,
    2.12985992e+00, -5.08824110e-01, -1.54036418e-01,  7.22487390e-01,
    6.77494824e-01,  3.77522558e-01,  8.49770069e-01,  8.07089627e-01,
   -2.44140252e-01, -3.79401237e-01, -2.41833663e+00, -4.68486816e-01,
   -2.20221147e-01,  1.05616473e-01,  1.38957834e+00,  5.81788383e-02]],

 [[ 4.27462235e-02,  5.30060112e-01,  7.17267171e-02,  3.32550108e-01,
    1.94677031e+00,  7.10077703e-01, -1.71634674e+00,  1.32034338e+00,
    1.57981479e+00, -1.60340583e+00, -3.69827718e-01,  1.06798947e+00,
   -6.26433432e-01, -9.63458955e-01,  8.73803794e-02,  1.85034494e-03,
   -3.56198609e-01, -4.02834594e-01, -9.31526840e-01,  2.78977960e-01,
   -7.76778698e-01,  1.03492999e+00, -2.58468892e-02, -7.86605895e-01,
    7.11058199e-01, -7.40605056e-01, -2.80882210e-01,  7.76377797e-01,
   -1.24862802e+00,  2.40630770e+00, -7.66214550e-01, -1.30336738e+00]],

 [[ 1.00304413e+00, -1.10402930e+00, -8.18589628e-01, -8.53838772e-02,
    1.63254344e+00,  1.65750301e+00,  5.10140181e-01, -2.19561100e-01,
    1.31731451e+00, -1.63461399e+00, -1.51553571e+00, -1.92926396e-04,
   -2.34598428e-01, -8.10957730e-01, -7.68198669e-02,  1.18702912e+00,
    1.02896476e+00, -7.97329992e-02,  3.11698347e-01, -1.05362326e-01,
   -1.64250886e+00, -5.83484530e-01, -1.92125186e-01,  1.34938622e+00,
   -1.43925950e-01,  1.06977129e+00, -2.00842762e+00,  1.95832565e-01,
   -8.68156493e-01,  1.09408700e+00,  6.28593624e-01, -8.61901224e-01]]
], dtype=np.float32)

GOLDEN_TEST_EXPECTED_POST_ACTIVATIONS_TRACKING_QAMNIST = np.array([
    [[-1.33766164e-03,  2.06364412e-03, -3.96376150e-03, -1.35172147e-03,
    7.26487339e-02, -8.92283916e-02,  1.41218829e-03, -1.18473340e-02,
    3.34048010e-02,  4.68923710e-02, -4.47248761e-03, -1.27485190e-02,
   -2.53083333e-02,  3.78744900e-02,  2.18202807e-02,  1.23253861e-03,
   -3.49605602e-04, -1.09697767e-02,  3.65996337e-03,  1.72467611e-03,
    1.30530447e-02,  4.18439321e-03,  6.96745282e-03, -1.16333214e-03,
    2.65309610e-03,  1.82737829e-03,  3.79778398e-03, -1.26832342e-02,
    4.93126595e-03, -2.44519264e-02, -6.13038568e-03, -1.71472027e-03]],

 [[-1.35675250e-02, -1.62720995e-03, -2.49336753e-03, -1.97684206e-03,
    4.43267152e-02, -7.30666146e-02,  1.19622806e-02,  8.24776664e-03,
    8.50359350e-02,  6.18354380e-02, -5.05772652e-03, -4.29086648e-02,
   -5.03886566e-02,  2.22138334e-02,  2.29907930e-02, -1.28050428e-02,
    2.24537700e-02, -1.31494356e-02,  5.41210501e-03,  1.84042305e-02,
    7.56576136e-02, -1.49251344e-02, -8.33570492e-03, -1.63200032e-03,
   -1.01566024e-03, -4.74165333e-03, -7.65771430e-04, -3.75269144e-03,
    4.47632791e-03, -1.31364539e-02,  1.37108462e-02,  2.29669665e-03]],

 [[-7.21005374e-04, -8.88697524e-03,  9.47425608e-03,  8.28172313e-04,
    7.32438788e-02, -5.78767993e-02,  8.02218392e-02,  3.92145403e-02,
    1.16712369e-01,  1.96439326e-02,  6.61999686e-03,  1.46308923e-02,
   -2.76868455e-02,  2.68913563e-02, -3.38146612e-02, -4.01294837e-03,
   -8.54037702e-03, -1.40285809e-02, -8.70388560e-03, -1.78369284e-02,
   -1.95458941e-02,  4.58569974e-02,  1.28053222e-02,  2.42947750e-02,
    2.16483232e-03,  1.22186716e-03,  9.67764179e-04, -1.62241384e-02,
   -1.02666840e-02, -1.94503926e-02, -2.02551819e-02, -1.50099993e-02]],

 [[ 1.57393720e-02, -2.38377843e-02, -8.74323212e-03, -3.74516496e-03,
    4.70262319e-02, -1.12104058e-01,  8.82608909e-03,  2.16351971e-02,
    1.77635446e-01, -8.42496939e-03, -1.18378848e-02, -2.41375808e-02,
    1.07469196e-02,  6.48246557e-02, -1.17943157e-02,  4.27878040e-05,
    3.45227644e-02, -4.22704704e-02, -1.73394792e-02, -6.85634464e-02,
   -5.69533072e-02, -3.44255865e-02, -9.37941205e-03, -1.12488195e-02,
   -8.48296192e-03, -2.39644721e-02,  6.85691973e-03, -4.07133112e-03,
   -1.89805776e-02,  1.82966776e-02,  6.05498161e-03, -6.53319061e-03]],

 [[-2.05637123e-02, -4.35313098e-02,  2.10054195e-03,  1.30820042e-03,
    8.34260210e-02, -5.18897474e-02, -5.62404804e-02,  1.78874642e-01,
    1.84914529e-01, -3.53012383e-02,  1.97966285e-02, -1.28196001e-01,
    3.27974074e-02,  3.85105424e-02,  3.73329259e-02, -2.80152019e-02,
   -1.41176768e-02, -2.80281454e-02,  2.45226314e-03,  2.31536217e-02,
    1.17213778e-01,  4.67678197e-02,  1.48505559e-02,  2.71775518e-02,
    2.01771408e-03, -6.69242740e-02, -6.70119887e-03, -7.47740222e-03,
    1.56456965e-03,  5.61539121e-02,  2.41325833e-02, -4.09730739e-04]],

 [[ 6.22349866e-02, -3.15943696e-02,  5.27199637e-03,  1.46548245e-02,
    2.19930410e-02, -4.73585799e-02,  6.48017004e-02,  1.09123431e-01,
    1.07792012e-01, -3.12979110e-02,  1.39759248e-02, -9.78219360e-02,
   -2.67457741e-04,  4.17276211e-02,  4.80498895e-02, -1.55087542e-02,
    3.98220215e-03, -3.49428430e-02, -9.71786771e-03,  2.25887951e-02,
    2.15126500e-02, -8.16158131e-02, -2.76646018e-02, -2.02524289e-02,
    5.83835226e-03,  1.93281304e-02,  1.09799410e-04,  5.95784886e-03,
   -1.07557727e-02,  1.33074060e-01,  3.01743150e-02,  1.35523817e-02]],

 [[-6.44928403e-03,  1.11715309e-02,  5.37870917e-03, -4.20692796e-03,
    1.58153966e-01, -5.82279302e-02, -4.47831377e-02,  2.46845037e-01,
    1.37464687e-01, -3.62692662e-02,  5.95465209e-03, -2.15564184e-02,
    5.95016629e-02,  6.09667040e-02,  1.08369710e-02,  2.71471795e-02,
   -7.94888586e-02, -3.60571966e-02,  3.25090461e-03, -3.22581381e-02,
   -2.25403961e-02,  3.83169726e-02,  1.10455537e-02,  8.25827569e-03,
    1.27401007e-02, -8.18203017e-03, -1.70549676e-02, -6.96395617e-03,
   -9.50165093e-03,  1.25370070e-01, -9.68785770e-03, -4.22835127e-02]],

 [[ 3.40220779e-02,  1.53608862e-02, -2.76468787e-02, -3.12211271e-02,
    1.47839896e-02, -9.95492712e-02,  7.04499260e-02,  8.41974020e-02,
    1.12993725e-01, -1.17821889e-02, -7.13726133e-03, -2.07293823e-01,
    3.59960236e-02,  4.48859595e-02,  1.59361772e-02, -3.64789255e-02,
    2.46970374e-02, -1.33754837e-03, -2.84238090e-03,  5.21615744e-02,
    1.31106555e-01, -8.39096829e-02, -1.78552624e-02, -3.80308963e-02,
   -1.29521284e-02,  3.15413252e-03, -4.52440828e-02, -5.82703669e-03,
    1.02473777e-02,  9.73751023e-02,  6.91662133e-02, -5.50994985e-02]]], dtype=np.float32)

GOLDEN_TEST_EXPECTED_ATTENTIONS_TRACKING_QAMNIST = np.array([[[
    [[0.01569004, 0.01571218, 0.01571218, 0.01571218, 0.01571192,
     0.01561665, 0.01566096, 0.01570849, 0.01573167, 0.01573530,
     0.01573530, 0.01573530, 0.01572861, 0.01530725, 0.01555706,
     0.01571878, 0.01573167, 0.01573530, 0.01573530, 0.01557517,
     0.01550415, 0.01532056, 0.01566321, 0.01571878, 0.01573167,
     0.01573500, 0.01525251, 0.01536767, 0.01557973, 0.01537311,
     0.01573602, 0.01571878, 0.01573167, 0.01555507, 0.01528285,
     0.01544607, 0.01544080, 0.01549932, 0.01573530, 0.01571878,
     0.01573167, 0.01546181, 0.01531235, 0.01550132, 0.01549685,
     0.01564463, 0.01573530, 0.01571878, 0.01573167, 0.01554071,
     0.01551160, 0.01573077, 0.01545797, 0.01572968, 0.01573530,
     0.01571878, 0.01573154, 0.01573154, 0.01573154, 0.01571423,
     0.01549537, 0.01573647, 0.01573154, 0.01570618]],

   [[0.01585286, 0.01592531, 0.01592531, 0.01592531, 0.01592458,
     0.01559703, 0.01575079, 0.01591353, 0.01598925, 0.01600150,
     0.01600150, 0.01600150, 0.01597892, 0.01449708, 0.01539079,
     0.01594565, 0.01598925, 0.01600150, 0.01600150, 0.01545183,
     0.01520572, 0.01455790, 0.01576741, 0.01594565, 0.01598925,
     0.01600051, 0.01429509, 0.01473967, 0.01549653, 0.01474701,
     0.01600420, 0.01594565, 0.01598925, 0.01538583, 0.01441899,
     0.01501528, 0.01500376, 0.01520201, 0.01600150, 0.01594565,
     0.01598925, 0.01507750, 0.01453814, 0.01523025, 0.01519921,
     0.01570554, 0.01600150, 0.01594565, 0.01598925, 0.01535543,
     0.01525562, 0.01598452, 0.01505712, 0.01600675, 0.01600150,
     0.01594565, 0.01598882, 0.01598882, 0.01598882, 0.01593025,
     0.01519104, 0.01601579, 0.01598882, 0.01590295]]]],

 [[[[0.01574792, 0.01577034, 0.01577027, 0.01580209, 0.01578700,
     0.01567837, 0.01573822, 0.01576659, 0.01579008, 0.01579375,
     0.01576773, 0.01526568, 0.01547377, 0.01545510, 0.01568484,
     0.01577705, 0.01579008, 0.01579375, 0.01577262, 0.01534254,
     0.01538840, 0.01554076, 0.01568665, 0.01577208, 0.01579008,
     0.01579375, 0.01556257, 0.01521694, 0.01542135, 0.01561582,
     0.01549444, 0.01577729, 0.01579008, 0.01565238, 0.01521619,
     0.01535870, 0.01564357, 0.01530644, 0.01542998, 0.01574902,
     0.01569378, 0.01539181, 0.01540244, 0.01557954, 0.01549248,
     0.01551331, 0.01560300, 0.01577523, 0.01563495, 0.01546142,
     0.01557485, 0.01559386, 0.01553444, 0.01567701, 0.01575816,
     0.01577705, 0.01575265, 0.01555892, 0.01556580, 0.01558891,
     0.01575188, 0.01578996, 0.01578995, 0.01576432]],

   [[0.01605289, 0.01612642, 0.01612621, 0.01623201, 0.01618087,
     0.01580896, 0.01601679, 0.01611446, 0.01619131, 0.01620375,
     0.01611536, 0.01432138, 0.01510947, 0.01503024, 0.01583129,
     0.01614707, 0.01619131, 0.01620375, 0.01613202, 0.01461806,
     0.01479211, 0.01536221, 0.01585925, 0.01613301, 0.01619131,
     0.01620375, 0.01540477, 0.01412737, 0.01492461, 0.01562724,
     0.01516918, 0.01614789, 0.01619131, 0.01571898, 0.01412323,
     0.01468820, 0.01572611, 0.01447151, 0.01495182, 0.01607369,
     0.01586141, 0.01480501, 0.01484647, 0.01547187, 0.01518793,
     0.01526538, 0.01558558, 0.01614268, 0.01566701, 0.01507548,
     0.01548847, 0.01555939, 0.01534362, 0.01583795, 0.01608277,
     0.01614707, 0.01606556, 0.01541734, 0.01543972, 0.01552134,
     0.01606135, 0.01619091, 0.01619088, 0.01610374]]
]]], dtype=np.float32)

GOLDEN_TEST_EXPECTED_EMBEDDINGS_TRACKING_QAMNIST = np.array([
  [[ 0.00000000,  1.00000000,  0.00000000,  1.00000000]],
  [[ 0.33669037,  0.12880941,  0.23446237,  0.23033303]],
  [[ 0.00000000,  1.00000000,  0.00000000,  1.00000000]],
  [[-1.12285638, -0.18632829,  2.20820141, -0.63799703]],
  [[ 0.00000000,  1.00000000,  0.00000000,  1.00000000]]
], dtype=np.float32)

# --- RL (Cartpole) ---

GOLDEN_TEST_EXPECTED_INITIAL_STATE_TRACE_RL = torch.tensor([[[-0.0329750888,  0.0652975887, -0.1467938125,  0.0946389735,
          -0.0510925315],
         [-0.1250535846,  0.0240389034,  0.0796450227,  0.1422704011,
          -0.1004136875],
         [-0.0809014440,  0.0316078216,  0.0445950665,  0.0632068440,
           0.0902345255],
         [-0.0372780785,  0.0913350880,  0.1212099865, -0.0429445542,
           0.1169628501],
         [ 0.0803219751,  0.1450085789, -0.0934236497, -0.0811816975,
          -0.0475341417],
         [ 0.0083393510,  0.0986720994, -0.0938492417,  0.0823070034,
          -0.0589175373],
         [ 0.0993149504, -0.0078052110, -0.1440277994, -0.0904598609,
          -0.1189840958],
         [ 0.0815357342, -0.1102374420, -0.0136974333,  0.0354700387,
          -0.0901555270],
         [ 0.0474241786, -0.1605230123, -0.1176288649, -0.1489657611,
          -0.0497269705],
         [-0.0598901212,  0.0235408433, -0.0303997509,  0.0772810131,
           0.1507202238],
         [ 0.0589848943, -0.0647678599, -0.1539408416,  0.0595456287,
          -0.0814527720],
         [ 0.0836587474,  0.1098982394,  0.0634120554,  0.1542573273,
           0.1561455727],
         [ 0.0348098241, -0.1197871417,  0.1468808502, -0.0780066252,
          -0.0776544511],
         [ 0.1375655532,  0.1273780316,  0.0496733710,  0.0103051560,
          -0.1382868141],
         [-0.0170652904,  0.1576793939,  0.0418656506,  0.0140755149,
          -0.0341376178],
         [-0.0573394559,  0.0979855284,  0.0101382416,  0.1069537401,
          -0.0290983915],
         [ 0.0718274266,  0.0678589568,  0.0262157395,  0.1033038870,
           0.1030199528],
         [ 0.1523852497,  0.1263859868, -0.0420362689, -0.1391835064,
           0.0300550051],
         [-0.0014349180, -0.0428794287, -0.0275293849,  0.0077321501,
           0.1199504063],
         [ 0.0512499399, -0.0583771430, -0.0676049665, -0.0407103375,
          -0.0635406971],
         [ 0.1478313208,  0.0870731547,  0.1484482884,  0.0005250273,
           0.0331544876],
         [ 0.0570077598, -0.1556123644,  0.0146802664, -0.0109966481,
          -0.0921709538],
         [-0.1275649518,  0.1455382109,  0.1336672306,  0.0761937797,
           0.1568776816],
         [-0.0667143986, -0.0283954367,  0.0622445121, -0.0271630809,
          -0.0322608054],
         [-0.1358858645,  0.0441676378, -0.0993507802,  0.0059785703,
           0.1602849960],
         [-0.0506045260, -0.0518172011,  0.0991840214, -0.0604418218,
          -0.0141181601],
         [ 0.1535056531, -0.0673992634, -0.1176127121, -0.0920048654,
          -0.0455789007],
         [-0.0780071095, -0.0853118524,  0.0664080605,  0.0279375892,
          -0.0526177958],
         [-0.1277234405, -0.0517626405, -0.0693828091, -0.0534985438,
          -0.1483080983],
         [ 0.0354163200, -0.1207878068, -0.1280337870, -0.1343194246,
           0.0686174482],
         [-0.0989725739, -0.0678558201,  0.1288626045,  0.0872899815,
           0.0942649320],
         [-0.1560979038, -0.1178904772, -0.0620624274,  0.1358096004,
           0.0168180820]]
           ], dtype=torch.float32, device="cpu")

GOLDEN_TEST_EXPECTED_INITIAL_ACTIVATED_STATE_TRACE_RL = torch.tensor([[[    -0.1229535341,      0.0010294378,     -0.1276838928,
              -0.0360196978,     -0.0452056192],
         [     0.1423138976,      0.0509204045,     -0.0286664348,
               0.0277717132,     -0.0474563204],
         [     0.0645924211,      0.0650302917,      0.0441487059,
              -0.0640789345,      0.1402571052],
         [    -0.0237342753,     -0.0640032664,      0.1029653922,
               0.1339944899,      0.1636032462],
         [     0.0487045683,     -0.0560426041,      0.0834969282,
               0.1410468519,     -0.1612481326],
         [    -0.0203668866,     -0.1121144295,      0.0306373555,
               0.0679929256,     -0.0339628421],
         [    -0.0137531497,      0.0739977583,     -0.0276304912,
              -0.1380589008,      0.1315415353],
         [    -0.0827443898,     -0.0180606283,      0.0155071607,
              -0.0098798629,     -0.1546478271],
         [     0.0754262432,     -0.0746751949,     -0.0852671117,
               0.0392774567,     -0.0857935846],
         [    -0.0759785771,     -0.0553942285,     -0.0617610142,
              -0.0686591715,     -0.0443360806],
         [     0.0427233130,     -0.1330346018,     -0.0995074660,
               0.0023988204,      0.0228626579],
         [     0.0907963216,     -0.1154810712,      0.0524756536,
               0.0934427008,      0.0912842080],
         [    -0.1531247497,     -0.0627353415,     -0.1413117200,
              -0.1040335521,      0.0915674195],
         [    -0.0245479010,      0.0698221102,     -0.0965032429,
               0.0249820519,     -0.0994380265],
         [     0.0821817368,     -0.0719046667,     -0.0412245467,
              -0.1426376998,      0.0005430966],
         [     0.1560935825,      0.0797956735,     -0.0877135918,
               0.0022109551,     -0.0180260967],
         [    -0.1323533803,      0.1289037764,      0.0026502220,
               0.0346219391,     -0.0663890764],
         [    -0.0769254267,      0.0271076784,      0.0607801005,
               0.0368743613,     -0.0792312771],
         [     0.1596146077,     -0.0242002532,     -0.1006804183,
              -0.0768914819,      0.1618377715],
         [     0.0000079175,     -0.0223162100,     -0.0684165731,
              -0.0430964381,     -0.1384615153],
         [    -0.1306451559,      0.0962209925,      0.1406350136,
               0.1568860114,     -0.1186865792],
         [     0.0889173746,     -0.1017574742,      0.0980738997,
               0.1186227873,      0.1272235960],
         [     0.1183756962,      0.1028436124,      0.0031998057,
               0.0755384415,     -0.0588171743],
         [     0.0715850443,     -0.0528381541,     -0.0027604799,
              -0.1430893987,     -0.0429861583],
         [    -0.0864529759,     -0.0554551966,     -0.1049829721,
              -0.1478677094,      0.0107050901],
         [     0.1066915169,      0.1497262865,      0.0959357098,
              -0.0852141380,     -0.1625922024],
         [     0.0623588078,      0.0921150446,     -0.1411385089,
               0.0589511842,      0.1389956027],
         [     0.0099587245,     -0.0990436226,      0.1347868294,
               0.0702009797,      0.1088652015],
         [    -0.1111806482,      0.0956712514,     -0.1122966111,
               0.1626718640,     -0.0696558058],
         [     0.0990614146,      0.0329195112,      0.0435674526,
              -0.0252114069,      0.0675244778],
         [    -0.0685168728,     -0.1549590677,     -0.0631625950,
               0.1288129389,     -0.0432812646],
         [     0.0516736284,     -0.0607826486,      0.1233237758,
               0.0983911902,      0.0580350831]]], dtype=torch.float32, device="cpu"
)

GOLDEN_TEST_EXPECTED_ACTION_RL = torch.tensor([0], dtype=torch.int64, device="cpu")

GOLDEN_TEST_EXPECTED_ACTION_LOG_PROB_RL = torch.tensor([-0.6931469440], dtype=torch.float32, device="cpu")

GOLDEN_TEST_EXPECTED_ENTROPY_RL = torch.tensor([0.6931471825], dtype=torch.float32, device="cpu")

GOLDEN_TEST_EXPECTED_VALUE_RL = torch.tensor([[0.0000000253]], dtype=torch.float32, device="cpu")

GOLDEN_TEST_EXPECTED_STATE_TRACE_RL = torch.tensor([[[ 0.3551222980,  0.3541408181,  0.3534789085,  0.3526154757,
           0.3541614711],
         [ 0.5530933142,  0.5649253726,  0.5665957332,  0.5641837120,
           0.5615332723],
         [-1.4967918396, -1.5040798187, -1.5078725815, -1.5055198669,
          -1.5030713081],
         [ 1.9012653828,  1.8963906765,  1.8976036310,  1.8986021280,
           1.8985152245],
         [-0.9695935845, -0.9658908248, -0.9679524302, -0.9650484324,
          -0.9676190615],
         [-0.9634177685, -0.9635293484, -0.9625963569, -0.9612380266,
          -0.9613040686],
         [ 0.2834188342,  0.2763278484,  0.2778175175,  0.2769760787,
           0.2765136957],
         [-1.1666585207, -1.1640322208, -1.1619160175, -1.1669970751,
          -1.1646679640],
         [ 0.4437283278,  0.4477409720,  0.4488375187,  0.4478521943,
           0.4467115998],
         [ 0.4784720838,  0.4794481099,  0.4809136391,  0.4780786932,
           0.4798108339],
         [ 1.9178813696,  1.9223668575,  1.9255268574,  1.9249228239,
           1.9250802994],
         [ 0.4319234192,  0.4251735508,  0.4238859117,  0.4258756936,
           0.4267497361],
         [ 0.6427566409,  0.6380707026,  0.6429569721,  0.6440083385,
           0.6393420100],
         [-1.8481410742, -1.8315404654, -1.8283659220, -1.8303927183,
          -1.8318014145],
         [-1.7050175667, -1.7076052427, -1.7090553045, -1.7088890076,
          -1.7079026699],
         [ 1.2828793526,  1.2895854712,  1.2895565033,  1.2866834402,
           1.2895244360],
         [-0.2489087284, -0.2573432624, -0.2580879331, -0.2560528815,
          -0.2573571205],
         [ 0.2501038015,  0.2463880479,  0.2443902045,  0.2484578490,
           0.2468959838],
         [-0.1942619979, -0.1926809698, -0.1966144294, -0.1953694075,
          -0.1956968307],
         [-0.6689880490, -0.6652735472, -0.6665555835, -0.6675652266,
          -0.6672182679],
         [-0.2735773623, -0.2758850753, -0.2721280158, -0.2754731774,
          -0.2744458914],
         [-0.7490212917, -0.7456380129, -0.7417908907, -0.7448751926,
          -0.7470892072],
         [-1.3131489754, -1.3182779551, -1.3177666664, -1.3192501068,
          -1.3197590113],
         [-0.5493766665, -0.5557487607, -0.5581672788, -0.5572485924,
          -0.5542625785],
         [ 0.6783219576,  0.6717574596,  0.6696543694,  0.6692429781,
           0.6684721708],
         [ 0.1099190339,  0.1020681709,  0.0980775803,  0.0990364552,
           0.1022970825],
         [ 0.3008604050,  0.3047142029,  0.3052355051,  0.3045068979,
           0.3030455410],
         [-0.6681752205, -0.6677473783, -0.6680489779, -0.6635195613,
          -0.6624295712],
         [ 1.8561905622,  1.8659675121,  1.8671470881,  1.8670636415,
           1.8658275604],
         [-0.0512642376, -0.0471137278, -0.0456182137, -0.0450106114,
          -0.0471458100],
         [ 1.4136502743,  1.4085147381,  1.3992835283,  1.4004067183,
           1.4046148062],
         [-0.0332443714, -0.0311939921, -0.0284253936, -0.0260630418,
          -0.0273243263]]], dtype=torch.float32, device="cpu")


GOLDEN_TEST_EXPECTED_ACTIVATED_STATE_TRACE_RL = torch.tensor([[[     0.0194696933,      0.0191284865,      0.0189961884,
               0.0194335598,      0.0204444136],
         [    -0.0168701075,     -0.0169367231,     -0.0194324832,
              -0.0174945928,     -0.0161889624],
         [     0.0268932153,      0.0252580754,      0.0268900376,
               0.0279226284,      0.0270580016],
         [     0.0019904599,      0.0015309420,      0.0012876581,
               0.0019751440,      0.0019579751],
         [     0.0736455545,      0.0729268491,      0.0725840777,
               0.0726265758,      0.0727986619],
         [    -0.0144715374,     -0.0137381786,     -0.0133340918,
              -0.0143542783,     -0.0140253920],
         [     0.0031931063,      0.0038685675,      0.0030736141,
               0.0026304834,      0.0027808393],
         [    -0.0247934777,     -0.0247894377,     -0.0245910641,
              -0.0251692422,     -0.0249126181],
         [     0.0025333674,      0.0025885238,      0.0030206563,
               0.0025996892,      0.0025199538],
         [     0.0036230662,      0.0052366313,      0.0060157008,
               0.0036209757,      0.0023756269],
         [     0.0401096866,      0.0419761948,      0.0408284031,
               0.0405559838,      0.0412773862],
         [    -0.0168228671,     -0.0197026692,     -0.0205096006,
              -0.0189813375,     -0.0176365729],
         [     0.0247772299,      0.0222693477,      0.0237768553,
               0.0253909864,      0.0265704300],
         [    -0.0377260894,     -0.0366867706,     -0.0385415405,
              -0.0407720618,     -0.0418509282],
         [    -0.0089503666,     -0.0084136389,     -0.0081214430,
              -0.0084811170,     -0.0084723895],
         [    -0.0829436928,     -0.0829612091,     -0.0821163505,
              -0.0820098221,     -0.0819315985],
         [    -0.0006523747,      0.0002193030,      0.0005623573,
               0.0004736879,     -0.0000307702],
         [     0.0012685056,      0.0013163635,      0.0017608658,
               0.0009315927,      0.0003975753],
         [     0.0053259265,      0.0050387871,      0.0056309537,
               0.0055704149,      0.0059406129],
         [     0.0192781202,      0.0185094569,      0.0185394380,
               0.0186598077,      0.0187069364],
         [    -0.0130200582,     -0.0132768517,     -0.0161990821,
              -0.0133895930,     -0.0152194761],
         [    -0.0053052041,     -0.0051641176,     -0.0048978589,
              -0.0051106513,     -0.0054068929],
         [    -0.0062983409,     -0.0052977740,     -0.0049087871,
              -0.0050204787,     -0.0044405614],
         [     0.0213107970,      0.0202474929,      0.0180792771,
               0.0187103692,      0.0186916720],
         [     0.0168894846,      0.0169810709,      0.0164871924,
               0.0143803200,      0.0133460779],
         [    -0.0005712177,     -0.0013322872,     -0.0016795677,
              -0.0019644625,     -0.0017810981],
         [     0.0118585899,      0.0128595997,      0.0121189337,
               0.0108436365,      0.0101299528],
         [    -0.0275860671,     -0.0239250157,     -0.0273028687,
              -0.0293493643,     -0.0297055617],
         [    -0.0206868965,     -0.0197244789,     -0.0174923223,
              -0.0187757593,     -0.0192922745],
         [    -0.0006188909,      0.0003015044,     -0.0011454417,
              -0.0007820151,     -0.0014569003],
         [    -0.0012555928,     -0.0019571770,     -0.0017393713,
              -0.0020562229,     -0.0018331809],
         [    -0.0027128870,     -0.0000133517,      0.0012202977,
               0.0004395723,      0.0006173401]]], dtype=torch.float32, device="cpu")



GOLDEN_TEST_EXPECTED_ACTION_LOGITS_RL = torch.tensor([[     0.0000002046,     -0.0000002722]], dtype=torch.float32, device="cpu")

GOLDEN_TEST_EXPECTED_ACTION_PROBS_RL = torch.tensor([[0.5000001192, 0.4999998808]], dtype=torch.float32, device="cpu")


GOLDEN_TEST_EXPECTED_PRE_ACTIVATIONS_TRACKING_RL = np.array([[[ 3.8843163848e-01,  4.6730560064e-01, -1.5841164589e+00,  2.0407147408e+00, -1.0384609699e+00,
           -1.0436526537e+00,  1.1848499626e-01, -1.1799826622e+00,  2.9973798990e-01,  5.7350206375e-01,
            1.9568263292e+00,  4.9663168192e-01,  9.1858589649e-01, -1.9897686243e+00, -1.5353472233e+00,
            1.1415734291e+00, -1.6399767250e-02,  3.1922909617e-01, -2.6233148575e-01, -4.5463111997e-01,
           -4.3630936742e-01, -6.6251003742e-01, -1.2630925179e+00, -4.8356220126e-01,  8.1540143490e-01,
           -4.3931324035e-02,  2.4176540971e-01, -6.3591754436e-01,  1.7592927217e+00, -7.4448026717e-02,
            1.1644541025e+00,  2.5243116543e-03]],
    
         [[ 3.1437510252e-01,  5.8834540844e-01, -1.5328428745e+00,  1.9049216509e+00, -9.2684066296e-01,
           -9.8599839211e-01,  2.2689513862e-01, -1.1244323254e+00,  4.9426192045e-01,  5.3176784515e-01,
            1.8823860884e+00,  4.0870073438e-01,  5.7401716709e-01, -1.7816010714e+00, -1.7228018045e+00,
            1.3253383636e+00, -3.0116450787e-01,  1.9685676694e-01, -1.6743634641e-01, -6.5027523041e-01,
           -2.3284265399e-01, -7.3857039213e-01, -1.3677948713e+00, -6.1925625801e-01,  5.7837772369e-01,
            8.0686010420e-02,  3.3615377545e-01, -6.3078588247e-01,  1.9514195919e+00, -8.0026080832e-03,
            1.3661587238e+00,  2.9984151945e-02]],
    
         [[ 3.5407865047e-01,  6.0110467672e-01, -1.5507193804e+00,  1.8675538301e+00, -9.5151227713e-01,
           -9.7110563517e-01,  1.6211138666e-01, -1.1531647444e+00,  4.7580626607e-01,  5.1735949516e-01,
            1.9456360340e+00,  3.6130067706e-01,  5.1921910048e-01, -1.7463333607e+00, -1.7292467356e+00,
            1.3352110386e+00, -3.2943287492e-01,  1.9007639587e-01, -1.2738622725e-01, -6.5386468172e-01,
           -2.2410561144e-01, -7.4103075266e-01, -1.3586324453e+00, -5.7223874331e-01,  5.3318279982e-01,
            6.9360993803e-02,  3.0975630879e-01, -5.3815954924e-01,  1.9293510914e+00, -1.2435991084e-04,
            1.4674665928e+00,  8.4813041613e-03]],
    
         [[ 3.2738628983e-01,  6.2736064196e-01, -1.5652279854e+00,  1.8630470037e+00, -9.5998537540e-01,
           -1.0043196678e+00,  2.4073961377e-01, -1.1247799397e+00,  4.9903124571e-01,  5.4225420952e-01,
            1.9074088335e+00,  3.4379786253e-01,  5.6365478039e-01, -1.7564239502e+00, -1.7182154655e+00,
            1.2970726490e+00, -3.2188323140e-01,  1.6929100454e-01, -1.5788167715e-01, -6.3610601425e-01,
           -2.1992485225e-01, -7.1171635389e-01, -1.3400319815e+00, -6.0251319408e-01,  6.0723859072e-01,
            7.2082057595e-02,  3.5615229607e-01, -6.0713744164e-01,  1.9453510046e+00, -5.0308993086e-03,
            1.4327079058e+00, -6.3397310674e-02]],
    
         [[ 2.9834258556e-01,  5.8498740196e-01, -1.5422463417e+00,  1.9032064676e+00, -9.7711098194e-01,
           -1.0102585554e+00,  3.0165958405e-01, -1.1221871376e+00,  4.7353482246e-01,  5.3012371063e-01,
            1.8952771425e+00,  3.8713687658e-01,  5.8664053679e-01, -1.8037649393e+00, -1.6943956614e+00,
            1.2908108234e+00, -2.8831177950e-01,  2.2175905108e-01, -1.6832798719e-01, -6.4275437593e-01,
           -1.9765289128e-01, -7.2437864542e-01, -1.3437278271e+00, -6.0380518436e-01,  6.2968534231e-01,
            7.6005376875e-02,  3.5440507531e-01, -6.6213887930e-01,  1.9407769442e+00, -1.1541866697e-02,
            1.3477253914e+00, -2.9474243522e-02]],
    
         [[ 3.5512229800e-01,  5.5309331417e-01, -1.4967918396e+00,  1.9012653828e+00, -9.6959358454e-01,
           -9.6341776848e-01,  2.8341883421e-01, -1.1666585207e+00,  4.4372832775e-01,  4.7847208381e-01,
            1.9178813696e+00,  4.3192341924e-01,  6.4275664091e-01, -1.8481410742e+00, -1.7050175667e+00,
            1.2828793526e+00, -2.4890872836e-01,  2.5010380149e-01, -1.9426199794e-01, -6.6898804903e-01,
           -2.7357736230e-01, -7.4902129173e-01, -1.3131489754e+00, -5.4937666655e-01,  6.7832195759e-01,
            1.0991903394e-01,  3.0086040497e-01, -6.6817522049e-01,  1.8561905622e+00, -5.1264237612e-02,
            1.4136502743e+00, -3.3244371414e-02]],
    
         [[ 3.5414081812e-01,  5.6492537260e-01, -1.5040798187e+00,  1.8963906765e+00, -9.6589082479e-01,
           -9.6352934837e-01,  2.7632784843e-01, -1.1640322208e+00,  4.4774097204e-01,  4.7944810987e-01,
            1.9223668575e+00,  4.2517355084e-01,  6.3807070255e-01, -1.8315404654e+00, -1.7076052427e+00,
            1.2895854712e+00, -2.5734326243e-01,  2.4638804793e-01, -1.9268096983e-01, -6.6527354717e-01,
           -2.7588507533e-01, -7.4563801289e-01, -1.3182779551e+00, -5.5574876070e-01,  6.7175745964e-01,
            1.0206817091e-01,  3.0471420288e-01, -6.6774737835e-01,  1.8659675121e+00, -4.7113727778e-02,
            1.4085147381e+00, -3.1193992123e-02]],
    
         [[ 3.5347890854e-01,  5.6659573317e-01, -1.5078725815e+00,  1.8976036310e+00, -9.6795243025e-01,
           -9.6259635687e-01,  2.7781751752e-01, -1.1619160175e+00,  4.4883751869e-01,  4.8091363907e-01,
            1.9255268574e+00,  4.2388591170e-01,  6.4295697212e-01, -1.8283659220e+00, -1.7090553045e+00,
            1.2895565033e+00, -2.5808793306e-01,  2.4439020455e-01, -1.9661442935e-01, -6.6655558348e-01,
           -2.7212801576e-01, -7.4179089069e-01, -1.3177666664e+00, -5.5816727877e-01,  6.6965436935e-01,
            9.8077580333e-02,  3.0523550510e-01, -6.6804897785e-01,  1.8671470881e+00, -4.5618213713e-02,
            1.3992835283e+00, -2.8425393626e-02]],
    
         [[ 3.5261547565e-01,  5.6418371201e-01, -1.5055198669e+00,  1.8986021280e+00, -9.6504843235e-01,
           -9.6123802662e-01,  2.7697607875e-01, -1.1669970751e+00,  4.4785219431e-01,  4.7807869315e-01,
            1.9249228239e+00,  4.2587569356e-01,  6.4400833845e-01, -1.8303927183e+00, -1.7088890076e+00,
            1.2866834402e+00, -2.5605288148e-01,  2.4845784903e-01, -1.9536940753e-01, -6.6756522655e-01,
           -2.7547317743e-01, -7.4487519264e-01, -1.3192501068e+00, -5.5724859238e-01,  6.6924297810e-01,
            9.9036455154e-02,  3.0450689793e-01, -6.6351956129e-01,  1.8670636415e+00, -4.5010611415e-02,
            1.4004067183e+00, -2.6063041762e-02]],
    
         [[ 3.5416147113e-01,  5.6153327227e-01, -1.5030713081e+00,  1.8985152245e+00, -9.6761906147e-01,
           -9.6130406857e-01,  2.7651369572e-01, -1.1646679640e+00,  4.4671159983e-01,  4.7981083393e-01,
            1.9250802994e+00,  4.2674973607e-01,  6.3934201002e-01, -1.8318014145e+00, -1.7079026699e+00,
            1.2895244360e+00, -2.5735712051e-01,  2.4689598382e-01, -1.9569683075e-01, -6.6721826792e-01,
           -2.7444589138e-01, -7.4708920717e-01, -1.3197590113e+00, -5.5426257849e-01,  6.6847217083e-01,
            1.0229708254e-01,  3.0304554105e-01, -6.6242957115e-01,  1.8658275604e+00, -4.7145809978e-02,
            1.4046148062e+00, -2.7324326336e-02]]], dtype=np.float32)

GOLDEN_TEST_EXPECTED_POST_ACTIVATIONS_TRACKING_RL = np.array([[[ 5.1293191500e-03,  2.1933196113e-02,  2.5343753397e-02, -1.9089911133e-02,  6.4718119800e-02,
           -1.6031375155e-02,  9.2305685394e-04, -1.1656722985e-02, -1.4917242806e-03, -2.1636748686e-02,
           -2.1225601435e-02, -2.2072868422e-02,  3.1463071704e-02,  2.0640464500e-02,  8.0340299755e-03,
           -7.9672075808e-03,  7.4481515912e-04,  3.1137429178e-03, -1.0617439402e-03,  1.9324265420e-02,
           -8.7446952239e-03, -1.5141480835e-03,  5.2837722003e-02, -6.6796303727e-03,  2.3842886090e-02,
           -1.3176264474e-03, -1.3241612352e-02, -2.5348238647e-02,  6.4427969046e-03, -7.6770693995e-03,
            1.7677277327e-02,  7.9699065536e-03]],
    
         [[ 1.0924331145e-03, -1.3595465571e-02,  9.5888338983e-02, -2.8482533991e-02,  8.8948659599e-02,
           -2.0215619355e-02,  2.6618463453e-03, -2.4987220764e-02,  1.1477348162e-03, -2.7057833970e-02,
           -2.1272126585e-02, -2.7865447104e-02, -9.0847201645e-03,  3.3617932349e-02,  2.0114956424e-02,
           -2.3629158735e-02,  3.6633862182e-03,  3.6372411996e-03,  2.4805283174e-03,  2.0328335464e-02,
           -4.6498524025e-03,  5.2979188040e-03,  1.6838598996e-02, -2.4308664724e-03,  2.8929257765e-02,
            3.1257767696e-03, -1.6058769077e-02, -2.5410659146e-03,  6.5935833845e-05,  3.1040955801e-03,
            2.6873485185e-03, -8.1385270460e-04]],
    
         [[ 9.6165807918e-03, -3.2711916137e-03,  5.8433871716e-02, -3.2651856542e-02,  9.1045349836e-02,
           -2.6584282517e-02,  3.5479075741e-03, -1.9272683188e-02, -7.0334319025e-04, -2.5609439239e-02,
           -2.8011262417e-02, -2.4834955111e-02, -1.3120434247e-02,  2.1631566808e-02,  7.8424094245e-03,
           -5.1234189421e-02,  7.9810013995e-04,  6.3883247785e-03,  6.3947606832e-03,  1.6463425010e-02,
           -2.1146371961e-02,  3.9120772853e-03,  1.5768254176e-02,  1.8042974174e-02,  4.4322222471e-02,
            8.0634903861e-04, -7.4427509680e-03,  6.6058286466e-03, -5.6025404483e-02, -5.0934008323e-03,
            2.9013468884e-03, -3.4867338836e-03]],
    
         [[ 1.3057023287e-02,  9.7236596048e-03,  6.9239363074e-03, -3.6746751517e-02,  6.8681925535e-02,
           -6.6598723643e-03,  4.9158362672e-03, -3.1458541751e-02, -1.1035013013e-03, -5.3433878347e-03,
           -4.7360729426e-02, -2.0910469815e-02,  1.3901184313e-02,  5.5523901246e-03, -2.0114075392e-02,
           -5.9459190816e-02, -1.8590749241e-03,  3.1907244120e-03,  3.8440752542e-04,  1.5148953535e-02,
            1.1363060912e-03,  3.0875392258e-03,  2.4820622057e-02,  1.9691176713e-02,  1.5137327835e-02,
            1.7961008416e-04,  2.0052592736e-03, -8.1149879843e-03, -3.5206913948e-02,  1.4940967085e-03,
           -4.4127088040e-03,  7.5083150296e-04]],
    
         [[ 1.9625917077e-02, -1.4340319671e-02,  2.9269848019e-02,  4.7088675201e-03,  7.4353024364e-02,
           -1.5366932377e-02,  3.3336177003e-03, -2.3636531085e-02,  2.8183064424e-03,  3.7855338305e-03,
            4.2675796896e-02, -1.1313996278e-02,  3.3971484751e-02, -4.6325728297e-02, -1.0198138654e-02,
           -8.0089174211e-02, -3.5084346309e-03, -1.2470344082e-03,  5.6482888758e-03,  1.7497450113e-02,
           -1.7149642110e-02, -4.5071151108e-03, -3.1449124217e-03,  1.8466204405e-02,  5.7629328221e-03,
           -1.2781595578e-03,  8.2537122071e-03, -3.1399536878e-02, -2.0421082154e-02, -1.1588806519e-03,
           -3.5993913189e-03, -1.4730019029e-03]],
    
         [[ 1.9469693303e-02, -1.6870107502e-02,  2.6893215254e-02,  1.9904598594e-03,  7.3645554483e-02,
           -1.4471537434e-02,  3.1931062695e-03, -2.4793477729e-02,  2.5333673693e-03,  3.6230662372e-03,
            4.0109686553e-02, -1.6822867095e-02,  2.4777229875e-02, -3.7726089358e-02, -8.9503666386e-03,
           -8.2943692803e-02, -6.5237469971e-04,  1.2685055844e-03,  5.3259264678e-03,  1.9278120250e-02,
           -1.3020058163e-02, -5.3052040748e-03, -6.2983408570e-03,  2.1310796961e-02,  1.6889484599e-02,
           -5.7121767895e-04,  1.1858589947e-02, -2.7586067095e-02, -2.0686896518e-02, -6.1889091739e-04,
           -1.2555927970e-03, -2.7128870133e-03]],
    
         [[ 1.9128486514e-02, -1.6936723143e-02,  2.5258075446e-02,  1.5309420414e-03,  7.2926849127e-02,
           -1.3738178648e-02,  3.8685675245e-03, -2.4789437652e-02,  2.5885237847e-03,  5.2366312593e-03,
            4.1976194829e-02, -1.9702669233e-02,  2.2269347683e-02, -3.6686770618e-02, -8.4136389196e-03,
           -8.2961209118e-02,  2.1930300863e-04,  1.3163634576e-03,  5.0387871452e-03,  1.8509456888e-02,
           -1.3276851736e-02, -5.1641175523e-03, -5.2977739833e-03,  2.0247492939e-02,  1.6981070861e-02,
           -1.3322872110e-03,  1.2859599665e-02, -2.3925015703e-02, -1.9724478945e-02,  3.0150444945e-04,
           -1.9571769517e-03, -1.3351695998e-05]],
    
         [[ 1.8996188417e-02, -1.9432483241e-02,  2.6890037581e-02,  1.2876581168e-03,  7.2584077716e-02,
           -1.3334091753e-02,  3.0736140907e-03, -2.4591064081e-02,  3.0206562951e-03,  6.0157007538e-03,
            4.0828403085e-02, -2.0509600639e-02,  2.3776855320e-02, -3.8541540504e-02, -8.1214429811e-03,
           -8.2116350532e-02,  5.6235730881e-04,  1.7608657945e-03,  5.6309537031e-03,  1.8539438024e-02,
           -1.6199082136e-02, -4.8978589475e-03, -4.9087870866e-03,  1.8079277128e-02,  1.6487192363e-02,
           -1.6795677366e-03,  1.2118933722e-02, -2.7302868664e-02, -1.7492322251e-02, -1.1454416672e-03,
           -1.7393713351e-03,  1.2202976504e-03]],
    
         [[ 1.9433559850e-02, -1.7494592816e-02,  2.7922628447e-02,  1.9751440268e-03,  7.2626575828e-02,
           -1.4354278333e-02,  2.6304833591e-03, -2.5169242173e-02,  2.5996891782e-03,  3.6209756508e-03,
            4.0555983782e-02, -1.8981337547e-02,  2.5390986353e-02, -4.0772061795e-02, -8.4811169654e-03,
           -8.2009822130e-02,  4.7368786181e-04,  9.3159265816e-04,  5.5704149418e-03,  1.8659807742e-02,
           -1.3389592990e-02, -5.1106512547e-03, -5.0204787403e-03,  1.8710369244e-02,  1.4380319975e-02,
           -1.9644624554e-03,  1.0843636468e-02, -2.9349364340e-02, -1.8775759265e-02, -7.8201509314e-04,
           -2.0562228747e-03,  4.3957226444e-04]],
    
         [[ 2.0444413647e-02, -1.6188962385e-02,  2.7058001608e-02,  1.9579750951e-03,  7.2798661888e-02,
           -1.4025392011e-02,  2.7808393352e-03, -2.4912618101e-02,  2.5199537631e-03,  2.3756269366e-03,
            4.1277386248e-02, -1.7636572942e-02,  2.6570430025e-02, -4.1850928217e-02, -8.4723895416e-03,
           -8.1931598485e-02, -3.0770166632e-05,  3.9757532068e-04,  5.9406128712e-03,  1.8706936389e-02,
           -1.5219476074e-02, -5.4068928584e-03, -4.4405614026e-03,  1.8691672012e-02,  1.3346077874e-02,
           -1.7810980789e-03,  1.0129952803e-02, -2.9705561697e-02, -1.9292274490e-02, -1.4569002669e-03,
           -1.8331808969e-03,  6.1734014889e-04]]], dtype=np.float32)

GOLDEN_TEST_SYNCH_OUT_TRACKING_RL = np.array([[ 2.0214383767e-06,  2.8881436265e-06, -4.3199912625e-07,  7.1648414632e-06, -3.2453951349e-07,  4.2142696657e-06]], dtype=np.float32)