import logging

ROOT_LOGGER_NAME = 'utils'


def init(name, level=logging.DEBUG, fmt=None, date_fmt=None, log_file=None):
    global ROOT_LOGGER_NAME
    ROOT_LOGGER_NAME = name

    fmt = fmt or '[%(process)d] [%(asctime)s] [%(levelname)s] [%(name)s]: %(message)s'
    date_fmt = date_fmt or '%Y-%m-%d %I:%M:%S'

    logger = logging.getLogger(name)
    logger.setLevel(level)

    if log_file is not None:
        handler = logging.FileHandler(log_file)
    else:
        handler = logging.StreamHandler()

    formatter = logging.Formatter(fmt, datefmt=date_fmt)
    handler.setFormatter(formatter)
    logger.addHandler(handler)
    logger.propagate = False

def get_logger(name):
    assert ROOT_LOGGER_NAME is not None, 'consider call init(...).'
    if (name is None) or (name == ROOT_LOGGER_NAME):
        return logging.getLogger(ROOT_LOGGER_NAME)
    return logging.getLogger(ROOT_LOGGER_NAME).getChild(name)


def disable_logger(name=None):
    global ROOT_LOGGER_NAME
    name = name or ROOT_LOGGER_NAME
    logger = get_logger(name)
    logger.disabled = True
    
# # initialize default logger
# init(name='utils')
