import numpy as np

import cv2 as cv

import matplotlib.pyplot as plt
import seaborn as sns

sns.set_style('whitegrid')

def show_images(images, nrows=5, ncols=5, keep_order=False, seed=None,
                figsize=(15, 15), display=True, filename=None, **kwargs):
    size = len(images)
    count = nrows * ncols
    assert size >= count, '...'
    random = np.random.RandomState(seed=seed)

    indices = np.arange(len(images))
    if keep_order:
        indices = indices[:count]
    else:
        indices = random.choice(indices, size=count, replace=False)

    fig, axs = plt.subplots(nrows=nrows, ncols=ncols, figsize=figsize)
    if nrows == 1 and ncols == 1:
        axs = np.array([axs])
    else:
        axs = axs.flatten()
    for i, idx in enumerate(indices):
        axs[i].imshow(images[idx], **kwargs)
        axs[i].axis('off')

    fig.tight_layout()
    if filename:
        fig.savefig(filename)
    if display:
        fig.show()
    else:
        return fig, axs
